/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.nosonar.NoSonarInfoParser;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S1309")
public class NoQaCommentCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Is #noqa used to exclude false-positive or to hide real quality flaw?";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                String commentLine = trivia.token().value();
                if (!NoSonarInfoParser.isValidNoQa((String)commentLine)) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
        });
    }
}

