/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7931")
public class NotImplementedBooleanContextCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "NotImplemented should not be used in boolean contexts.";
    private boolean isPython314OrGreater = false;
    private TypeCheckBuilder isBoolCallCheck;
    private TypeCheckBuilder isNotImplementedCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> this.raiseIfIsNotImplemented((SubscriptionContext)ctx, ((IfStatement)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_IF, ctx -> this.raiseIfIsNotImplemented((SubscriptionContext)ctx, ((ComprehensionIf)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> this.raiseIfIsNotImplemented((SubscriptionContext)ctx, ((ConditionalExpression)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.AND, this::checkBooleanOperation);
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, ctx -> this.raiseIfIsNotImplemented((SubscriptionContext)ctx, ((WhileStatement)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, this::checkIsExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.OR, this::checkBooleanOperation);
        context.registerSyntaxNodeConsumer(Tree.Kind.NOT, ctx -> this.raiseIfIsNotImplemented((SubscriptionContext)ctx, ((UnaryExpression)ctx.syntaxNode()).expression()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkBoolCall);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.isBoolCallCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("bool");
        this.isNotImplementedCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("_NotImplementedType");
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_314);
    }

    private void checkIsExpression(SubscriptionContext ctx) {
        IsExpression isExpression = (IsExpression)ctx.syntaxNode();
        if (NotImplementedBooleanContextCheck.isBooleanLiteral(isExpression.leftOperand()) || NotImplementedBooleanContextCheck.isBooleanLiteral(isExpression.rightOperand())) {
            this.raiseIfIsNotImplemented(ctx, isExpression.leftOperand());
            this.raiseIfIsNotImplemented(ctx, isExpression.rightOperand());
        }
    }

    private void raiseIfIsNotImplemented(SubscriptionContext ctx, Expression expression) {
        if (this.isPython314OrGreater && expression instanceof Name && this.isNotImplementedCheck.check(expression.typeV2()).isTrue()) {
            ctx.addIssue((Tree)expression, MESSAGE);
        }
    }

    private static boolean isBooleanLiteral(Expression expression) {
        return TreeUtils.isBooleanLiteral((Tree)expression);
    }

    private void checkBooleanOperation(SubscriptionContext ctx) {
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        this.raiseIfIsNotImplemented(ctx, binaryExpression.leftOperand());
        this.raiseIfIsNotImplemented(ctx, binaryExpression.rightOperand());
    }

    private void checkBoolCall(SubscriptionContext ctx) {
        Object e;
        CallExpression callExpr = (CallExpression)ctx.syntaxNode();
        if (this.isBoolCallCheck.check(callExpr.callee().typeV2()).isTrue() && callExpr.arguments().size() == 1 && (e = callExpr.arguments().get(0)) instanceof RegularArgument) {
            RegularArgument regularArgument = (RegularArgument)e;
            this.raiseIfIsNotImplemented(ctx, regularArgument.expression());
        }
    }
}

