/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ReturnCheckUtils;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S935")
public class SpecialMethodReturnTypeCheck
extends PythonSubscriptionCheck {
    private static final Map<String, String> METHOD_TO_RETURN_TYPE = Map.of("__bool__", "bool", "__index__", "int", "__repr__", "str", "__str__", "str", "__bytes__", "bytes", "__hash__", "int", "__format__", "str", "__getnewargs__", "tuple", "__getnewargs_ex__", "tuple", "__len__", "int");
    private static final String INVALID_RETURN_TYPE_MESSAGE = "Return a value of type `%s` here.";
    private static final String INVALID_RETURN_TYPE_MESSAGE_NO_LOCATION = "Return a value of type `%s` in this method.";
    private static final String NO_RETURN_STMTS_MESSAGE = "Return a value of type `%s` in this method. Consider explicitly raising a TypeError if this class is not meant to support this method.";
    private static final String COROUTINE_METHOD_MESSAGE = "Return a value of type `%s` in this method. The method can not be a coroutine and have the `async` keyword.";
    private static final String GENERATOR_METHOD_MESSAGE = "Return a value of type `%s` in this method. The method can not be a generator and contain `yield` expressions.";
    private static final String INVALID_GETNEWARGSEX_TUPLE_MESSAGE = String.format("Return a value of type `%s` here.", "tuple[tuple, dict]");
    private static final String INVALID_GETNEWARGSEX_ELEMENT_COUNT_MESSAGE = INVALID_GETNEWARGSEX_TUPLE_MESSAGE + " A tuple of two elements was expected but found tuple with %d element(s).";
    private TypeCheckBuilder isTorchDataSetTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> this.checkClassDefinition((SubscriptionContext)ctx, (ClassDef)ctx.syntaxNode()));
    }

    private void setupTypeChecks(SubscriptionContext ctx) {
        this.isTorchDataSetTypeCheck = ctx.typeChecker().typeCheckBuilder().isSubtypeOf("torch.utils.data.Dataset");
    }

    private void checkClassDefinition(SubscriptionContext ctx, ClassDef classDef) {
        for (FunctionDef methodDef : TreeUtils.topLevelFunctionDefs((ClassDef)classDef)) {
            this.checkFunctionDefinition(ctx, methodDef, CheckUtils.mustBeAProtocolLike(classDef));
        }
    }

    private void checkFunctionDefinition(SubscriptionContext ctx, FunctionDef funDef, boolean classIsProtocolLike) {
        String funNameString = funDef.name().name();
        String expectedReturnType = METHOD_TO_RETURN_TYPE.get(funNameString);
        if (expectedReturnType == null) {
            return;
        }
        ReturnCheckUtils.addIssueIfAsync(ctx, funDef, String.format(COROUTINE_METHOD_MESSAGE, expectedReturnType));
        ReturnCheckUtils.ReturnStmtCollector returnStmtCollector = ReturnCheckUtils.ReturnStmtCollector.collect(funDef);
        List<Token> yieldKeywords = returnStmtCollector.getYieldKeywords();
        for (Token yieldKeyword : yieldKeywords) {
            ctx.addIssue(yieldKeyword, String.format(GENERATOR_METHOD_MESSAGE, expectedReturnType));
        }
        if (SpecialMethodReturnTypeCheck.hasOnlyEllipsisOrDocStrBody(funDef)) {
            return;
        }
        List<ReturnStatement> returnStmts = returnStmtCollector.getReturnStmts();
        if (returnStmts.isEmpty() && yieldKeywords.isEmpty() && !returnStmtCollector.raisesExceptions() && !CheckUtils.isAbstract(funDef) && !classIsProtocolLike) {
            ctx.addIssue(funDef.defKeyword(), funDef.colon(), String.format(NO_RETURN_STMTS_MESSAGE, expectedReturnType));
            return;
        }
        for (ReturnStatement returnStmt : returnStmts) {
            this.checkReturnStmt(ctx, funNameString, expectedReturnType, returnStmt);
        }
    }

    private static boolean hasOnlyEllipsisOrDocStrBody(FunctionDef funDef) {
        ExpressionStatement expressionStmnt;
        List expressions;
        List statements = funDef.body().statements();
        if (statements.size() != 1) {
            return false;
        }
        Statement statement = (Statement)statements.get(0);
        if (statement instanceof ExpressionStatement && (expressions = (expressionStmnt = (ExpressionStatement)statement).expressions()).size() == 1) {
            return ((Expression)expressions.get(0)).is(new Tree.Kind[]{Tree.Kind.ELLIPSIS, Tree.Kind.STRING_LITERAL});
        }
        return false;
    }

    private void checkReturnStmt(SubscriptionContext ctx, String methodName, String expectedReturnType, ReturnStatement returnStmt) {
        List returnedExpressions = returnStmt.expressions();
        if (returnedExpressions.isEmpty()) {
            ctx.addIssue(returnStmt.returnKeyword(), String.format(INVALID_RETURN_TYPE_MESSAGE_NO_LOCATION, expectedReturnType));
            return;
        }
        if ("__len__".equals(methodName) && this.isDatasetLenNoncompliant(returnStmt)) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStmt, String.format(INVALID_RETURN_TYPE_MESSAGE, expectedReturnType));
            return;
        }
        InferredType returnStmtType = returnStmt.returnValueType();
        if (!returnStmtType.canBeOrExtend(expectedReturnType)) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStmt, String.format(INVALID_RETURN_TYPE_MESSAGE, expectedReturnType));
            return;
        }
        if ("__getnewargs_ex__".equals(methodName)) {
            SpecialMethodReturnTypeCheck.isGetNewArgsExCompliant(ctx, returnStmt);
        }
    }

    private static void isGetNewArgsExCompliant(SubscriptionContext ctx, ReturnStatement returnStatement) {
        List returnedExpressions = returnStatement.expressions();
        int numReturnedExpressions = returnedExpressions.size();
        if (numReturnedExpressions == 1) {
            Expression firstExpression = (Expression)returnedExpressions.get(0);
            if (firstExpression instanceof TupleImpl) {
                TupleImpl tupleImpl = (TupleImpl)firstExpression;
                returnedExpressions = tupleImpl.elements();
                numReturnedExpressions = returnedExpressions.size();
            } else {
                return;
            }
        }
        if (numReturnedExpressions != 2) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStatement, String.format(INVALID_GETNEWARGSEX_ELEMENT_COUNT_MESSAGE, numReturnedExpressions));
            return;
        }
        Expression firstElement = (Expression)returnedExpressions.get(0);
        Expression secondElement = (Expression)returnedExpressions.get(1);
        if (!firstElement.type().canBeOrExtend("tuple") || !secondElement.type().canBeOrExtend("dict")) {
            ctx.addIssue(firstElement.firstToken(), secondElement.lastToken(), INVALID_GETNEWARGSEX_TUPLE_MESSAGE);
        }
    }

    private boolean isDatasetLenNoncompliant(ReturnStatement returnStatement) {
        if (!this.isEnclosingClassExtendingDataset((Tree)returnStatement)) {
            return false;
        }
        Expression returnExpression = (Expression)returnStatement.expressions().get(0);
        return SpecialMethodReturnTypeCheck.isShape(returnExpression);
    }

    private boolean isEnclosingClassExtendingDataset(Tree tree) {
        ClassDef enclosingClass = SpecialMethodReturnTypeCheck.getEnclosingClass(tree);
        return enclosingClass != null && this.isTorchDataSetTypeCheck.check(enclosingClass.name().typeV2()).isTrue();
    }

    @CheckForNull
    private static ClassDef getEnclosingClass(Tree tree) {
        Tree functionDef = TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
        if (functionDef == null) {
            return null;
        }
        return (ClassDef)TreeUtils.firstAncestorOfClass((Tree)functionDef, ClassDef.class);
    }

    private static boolean isShape(Expression expr) {
        QualifiedExpression qualifiedExpression;
        return expr instanceof QualifiedExpression && "shape".equals((qualifiedExpression = (QualifiedExpression)expr).name().name());
    }
}

