/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6883")
public class StrftimeConfusingHourSystemCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Use %I (12-hour clock) or %H (24-hour clock) without %p (AM/PM).";
    public static final String MESSAGE_12_HOURS = "Use %I (12-hour clock) with %p (AM/PM).";
    private static final String MESSAGE_SECONDARY_LOCATION = "Wrong format created here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, StrftimeConfusingHourSystemCheck::checkCallExpr);
    }

    private static void checkExpression(SubscriptionContext context, Expression expression) {
        StrftimeConfusingHourSystemCheck.checkExpression(context, expression, (Tree)expression);
    }

    private static void checkExpression(SubscriptionContext context, Expression expression, Tree primaryLocation) {
        Expressions.ifNameGetSingleAssignedNonNameValue(expression).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).filter(stringLiteral -> stringLiteral.stringElements().stream().noneMatch(stringElement -> "f".equalsIgnoreCase(stringElement.prefix()))).ifPresent(stringLiteral -> StrftimeConfusingHourSystemCheck.checkDateFormatStringLiteral(context, primaryLocation, stringLiteral));
    }

    private static void checkDateFormatStringLiteral(SubscriptionContext context, Tree primaryLocation, StringLiteral stringLiteral) {
        String value = stringLiteral.trimmedQuotesValue();
        String effectiveMessage = null;
        if (value.contains("%H") && value.contains("%p")) {
            effectiveMessage = MESSAGE;
        } else if (value.contains("%I") && !value.contains("%p")) {
            effectiveMessage = MESSAGE_12_HOURS;
        }
        if (effectiveMessage != null) {
            PythonCheck.PreciseIssue issue = context.addIssue(primaryLocation, effectiveMessage);
            if (primaryLocation != stringLiteral) {
                issue.secondary((Tree)stringLiteral, MESSAGE_SECONDARY_LOCATION);
            }
        }
    }

    private static void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return;
        }
        String fullyQualifiedName = calleeSymbol.fullyQualifiedName();
        if (!"datetime.time.strftime".equals(fullyQualifiedName)) {
            return;
        }
        RegularArgument formatArgument = TreeUtils.nthArgumentOrKeyword((int)0, (String)"format", (List)callExpression.arguments());
        if (formatArgument == null) {
            return;
        }
        StrftimeConfusingHourSystemCheck.checkExpression(context, formatArgument.expression());
    }
}

