/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7489")
public class SynchronousOsCallsInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a thread executor to wrap blocking OS calls in this async function.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String TRIO_QUICK_FIX = "Wrap with \"await trio.thread.executor\".";
    private static final String ANYIO_QUICK_FIX = "Wrap with \"await anyio.thread.executor\".";
    private static final String TRIO = "trio";
    private static final String ANYIO = "anyio";
    private static final String THREAD_RUN_SYNC_FORMAT = "%s.to_thread.run_sync";
    private static final Set<String> OS_BLOCKING_CALLS = Set.of("os.wait", "os.waitpid", "os.waitid");
    private TypeCheckMap<Object> syncOsCallsTypeChecks;
    private final Map<String, String> asyncLibraryAliases = new HashMap<String, String>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::trackAsyncLibraryImports);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkSyncOsCallsInAsync);
    }

    private void setupTypeChecks(SubscriptionContext ctx) {
        this.syncOsCallsTypeChecks = new TypeCheckMap();
        Object object = new Object();
        OS_BLOCKING_CALLS.forEach(path -> this.syncOsCallsTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(path), object));
        this.asyncLibraryAliases.clear();
    }

    private void trackAsyncLibraryImports(SubscriptionContext ctx) {
        ImportName importName = (ImportName)ctx.syntaxNode();
        for (AliasedName module : importName.modules()) {
            String moduleAlias;
            List names = module.dottedName().names();
            if (names.size() > 1) continue;
            String moduleName = ((Name)names.get(0)).name();
            Name alias = module.alias();
            String string = moduleAlias = alias != null ? alias.name() : moduleName;
            if (!TRIO.equals(moduleName) && !ANYIO.equals(moduleName)) continue;
            this.asyncLibraryAliases.put(moduleName, moduleAlias);
        }
    }

    private void checkSyncOsCallsInAsync(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction((Tree)callExpression).orElse(null);
        if (asyncToken == null) {
            return;
        }
        this.syncOsCallsTypeChecks.getOptionalForType(callExpression.callee().typeV2()).ifPresent(object -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callExpression.callee(), MESSAGE).secondary(asyncToken, SECONDARY_MESSAGE);
            this.addQuickFixes(issue, callExpression);
        });
    }

    private void addQuickFixes(PythonCheck.PreciseIssue issue, CallExpression callExpression) {
        Optional calleeDottedName = TreeUtils.stringValueFromNameOrQualifiedExpression((Expression)callExpression.callee());
        if (calleeDottedName.isPresent()) {
            String alias;
            if (this.asyncLibraryAliases.containsKey(TRIO)) {
                alias = this.asyncLibraryAliases.get(TRIO);
                issue.addQuickFix(SynchronousOsCallsInAsyncCheck.createThreadExecutorQuickFix(callExpression, String.format(THREAD_RUN_SYNC_FORMAT, alias), (String)calleeDottedName.get(), TRIO_QUICK_FIX));
            }
            if (this.asyncLibraryAliases.containsKey(ANYIO)) {
                alias = this.asyncLibraryAliases.get(ANYIO);
                issue.addQuickFix(SynchronousOsCallsInAsyncCheck.createThreadExecutorQuickFix(callExpression, String.format(THREAD_RUN_SYNC_FORMAT, alias), (String)calleeDottedName.get(), ANYIO_QUICK_FIX));
            }
        }
    }

    private static PythonQuickFix createThreadExecutorQuickFix(CallExpression callExpression, String executorPrefix, String calleeDottedName, String message) {
        return PythonQuickFix.newQuickFix((String)message).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)callExpression.callee(), (String)("await " + executorPrefix))}).addTextEdit(new PythonTextEdit[]{TextEditUtils.insertAfter((Tree)callExpression.leftPar(), (String)(calleeDottedName + (callExpression.arguments().isEmpty() ? "" : ", ")))}).build();
    }
}

