/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7487")
public class SynchronousSubprocessOperationsInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use an async subprocess call in this async function instead of a synchronous one.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final Set<String> SYNC_SUBPROCESS_CALLS = Set.of("subprocess.run", "subprocess.Popen", "subprocess.call", "subprocess.check_call", "subprocess.check_output", "subprocess.getstatusoutput", "subprocess.getoutput", "os.system", "os.popen", "os.spawnl", "os.spawnle", "os.spawnlp", "os.spawnlpe", "os.spawnv", "os.spawnve", "os.spawnvp", "os.spawnvpe");
    private TypeCheckMap<Object> allSyncTypeChecks;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckMap);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void initializeTypeCheckMap(SubscriptionContext ctx) {
        Object marker = new Object();
        this.allSyncTypeChecks = new TypeCheckMap();
        SYNC_SUBPROCESS_CALLS.forEach(fqn -> this.allSyncTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(fqn), marker));
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        QualifiedExpression member;
        CallExpression call = (CallExpression)ctx.syntaxNode();
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction((Tree)call).orElse(null);
        if (asyncToken == null) {
            return;
        }
        if (this.allSyncTypeChecks.getOptionalForType(call.callee().typeV2()).isPresent()) {
            ctx.addIssue((Tree)call.callee(), MESSAGE).secondary(asyncToken, SECONDARY_MESSAGE);
            return;
        }
        Expression expression = call.callee();
        if (expression instanceof QualifiedExpression && this.allSyncTypeChecks.getOptionalForType((member = (QualifiedExpression)expression).qualifier().typeV2()).isPresent()) {
            ctx.addIssue((Tree)call.callee(), MESSAGE).secondary(asyncToken, SECONDARY_MESSAGE);
        }
    }
}

