/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6929")
public class TfPyTorchSpecifyReductionAxisCheck
extends PythonSubscriptionCheck {
    private static final Set<String> TF_REDUCTION_FUNCTIONS = new HashSet<String>(Arrays.asList("reduce_all", "reduce_mean", "reduce_any", "reduce_euclidean_norm", "reduce_logsumexp", "reduce_max", "reduce_min", "reduce_prod", "reduce_std", "reduce_sum", "reduce_variance"));
    private static final Set<String> TF_REDUCTION_FUNCTIONS_FQN = new HashSet<String>();
    private static final String TF_MESSAGE = "Provide a value for the axis argument.";
    public static final String AXIS_PARAMETER = "axis";
    public static final int AXIS_PARAMETER_POSITION = 1;
    private static final String PY_TORCH_MESSAGE = "Provide a value for the dim argument.";
    public static final String DIM_PARAMETER = "dim";
    public static final int NO_POSITIONAL_ARG = -1;
    private static final Map<String, Integer> PY_TORCH_REDUCTION_FUNCTIONS_DIM_POS;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, TfPyTorchSpecifyReductionAxisCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol != null && !Expressions.containsSpreadOperator(callExpression.arguments())) {
            if (TfPyTorchSpecifyReductionAxisCheck.isTfReductionMissingAxisArg(symbol, callExpression)) {
                PythonCheck.PreciseIssue issue = context.addIssue((Tree)callExpression.callee(), TF_MESSAGE);
                TfPyTorchSpecifyReductionAxisCheck.createTfQuickFix(callExpression).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
            }
            if (TfPyTorchSpecifyReductionAxisCheck.isPyTorchReductionMissingDimArg(symbol, callExpression)) {
                context.addIssue((Tree)callExpression.callee(), PY_TORCH_MESSAGE);
            }
        }
    }

    private static Optional<PythonQuickFix> createTfQuickFix(CallExpression callExpression) {
        if (callExpression.arguments().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PythonQuickFix.newQuickFix((String)"Add axis parameter", (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.insertBefore((Tree)callExpression.rightPar(), (String)", axis=None")}));
    }

    private static boolean isTfReductionMissingAxisArg(Symbol symbol, CallExpression callExpression) {
        return TF_REDUCTION_FUNCTIONS_FQN.contains(symbol.fullyQualifiedName()) && TreeUtils.nthArgumentOrKeyword((int)1, (String)AXIS_PARAMETER, (List)callExpression.arguments()) == null;
    }

    private static boolean isPyTorchReductionMissingDimArg(Symbol symbol, CallExpression callExpression) {
        String fqn = symbol.fullyQualifiedName();
        return fqn != null && PY_TORCH_REDUCTION_FUNCTIONS_DIM_POS.containsKey(fqn) && TreeUtils.nthArgumentOrKeyword((int)PY_TORCH_REDUCTION_FUNCTIONS_DIM_POS.get(fqn), (String)DIM_PARAMETER, (List)callExpression.arguments()) == null;
    }

    static {
        for (String reductionFunction : TF_REDUCTION_FUNCTIONS) {
            TF_REDUCTION_FUNCTIONS_FQN.add("tensorflow.math." + reductionFunction);
            TF_REDUCTION_FUNCTIONS_FQN.add("tensorflow.tf." + reductionFunction);
        }
        PY_TORCH_REDUCTION_FUNCTIONS_DIM_POS = Map.ofEntries(Map.entry("torch.argmin", 1), Map.entry("torch.aminmax", -1), Map.entry("torch.nanmean", 1), Map.entry("torch.mode", 1), Map.entry("torch.norm", 2), Map.entry("torch.quantile", 2), Map.entry("torch.nanquantile", 2), Map.entry("torch.std", 1), Map.entry("torch.std_mean", 1), Map.entry("torch.unique", 4), Map.entry("torch.unique_consecutive", 3), Map.entry("torch.var", 1), Map.entry("torch.var_mean", 1), Map.entry("torch.count_nonzero", 1));
    }
}

