/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7488")
public class TimeSleepInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this call to time.sleep() with an asynchronous sleep function.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String SLEEP_QUICK_FIX = "Replace with %s.sleep()";
    private TypeCheckBuilder isTimeSleepCall;
    private final Map<String, String> asyncLibraryAliases = new HashMap<String, String>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::checkImportName);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkTimeSleepInAsync);
    }

    private void setupCheck(SubscriptionContext ctx) {
        this.isTimeSleepCall = ctx.typeChecker().typeCheckBuilder().isTypeWithName("time.sleep");
        this.asyncLibraryAliases.clear();
    }

    private void checkImportName(SubscriptionContext ctx) {
        ImportName importName = (ImportName)ctx.syntaxNode();
        for (AliasedName module : importName.modules()) {
            String moduleAlias;
            List names = module.dottedName().names();
            if (names.size() > 1) continue;
            String moduleName = ((Name)names.get(0)).name();
            Name alias = module.alias();
            String string = moduleAlias = alias != null ? alias.name() : moduleName;
            if (!"asyncio".equals(moduleName) && !"trio".equals(moduleName) && !"anyio".equals(moduleName)) continue;
            this.asyncLibraryAliases.put(moduleName, moduleAlias);
        }
    }

    private void checkTimeSleepInAsync(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Expression callee = callExpression.callee();
        if (this.isTimeSleepCall.check(callee.typeV2()) != TriBool.TRUE) {
            return;
        }
        TreeUtils.asyncTokenOfEnclosingFunction((Tree)callExpression).ifPresent(asyncKeyword -> {
            PythonCheck.PreciseIssue issue = context.addIssue((Tree)callee, MESSAGE).secondary(asyncKeyword, SECONDARY_MESSAGE);
            this.addQuickFixes(issue, callExpression);
        });
    }

    private void addQuickFixes(PythonCheck.PreciseIssue issue, CallExpression callExpression) {
        this.asyncLibraryAliases.forEach((library, alias) -> {
            String message = String.format(SLEEP_QUICK_FIX, alias);
            issue.addQuickFix(TimeSleepInAsyncCheck.createQuickFix(callExpression, alias + ".sleep", message));
        });
    }

    private static PythonQuickFix createQuickFix(CallExpression callExpression, String replacementFunction, String message) {
        return PythonQuickFix.newQuickFix((String)message).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)callExpression.callee(), (String)replacementFunction)}).build();
    }
}

