/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S6546")
public class UnionTypeExpressionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a union type expression for this type hint.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_TYPE_ANNOTATION, UnionTypeExpressionCheck::checkTypeAnnotation);
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_TYPE_ANNOTATION, UnionTypeExpressionCheck::checkTypeAnnotation);
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, UnionTypeExpressionCheck::checkTypeAnnotation);
    }

    private static void checkTypeAnnotation(SubscriptionContext ctx) {
        if (!UnionTypeExpressionCheck.supportsUnionTypeExpressions(ctx)) {
            return;
        }
        TypeAnnotation typeAnnotation = (TypeAnnotation)ctx.syntaxNode();
        Expression expression = typeAnnotation.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.BITWISE_OR})) {
            return;
        }
        InferredType type = InferredTypes.fromTypeAnnotation((TypeAnnotation)typeAnnotation);
        String fqn = InferredTypes.fullyQualifiedTypeName((InferredType)type);
        if ("typing.Union".equals(fqn)) {
            ctx.addIssue((Tree)expression, MESSAGE);
        }
    }

    private static boolean supportsUnionTypeExpressions(SubscriptionContext ctx) {
        return PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_310);
    }
}

