/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tests.UnittestUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5899")
public class NotDiscoverableTestMethodCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename this method so that it starts with \"test\" or remove this unused helper.";
    private final Set<String> globalFixture = new HashSet<String>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> this.lookForGlobalFixture((FunctionDef)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDefinition = (ClassDef)ctx.syntaxNode();
            if (NotDiscoverableTestMethodCheck.inheritsOnlyFromUnitTest(classDefinition)) {
                HashMap<FunctionSymbol, FunctionDef> suspiciousFunctionsAndDefinitions = new HashMap<FunctionSymbol, FunctionDef>();
                HashSet<Tree> allDefinitions = new HashSet<Tree>();
                Set<String> classFixtures = NotDiscoverableTestMethodCheck.getFixturesFromClass(classDefinition);
                for (Statement statement : classDefinition.body().statements()) {
                    if (!statement.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) continue;
                    FunctionDef functionDef = (FunctionDef)statement;
                    if (!this.isException(functionDef, classFixtures)) {
                        Optional.ofNullable(functionDef.name().symbol()).filter(symbol -> symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})).ifPresent(symbol -> suspiciousFunctionsAndDefinitions.put((FunctionSymbol)symbol, functionDef));
                    }
                    allDefinitions.add((Tree)functionDef);
                }
                NotDiscoverableTestMethodCheck.checkSuspiciousFunctionsUsages(ctx, suspiciousFunctionsAndDefinitions, allDefinitions);
            }
        });
    }

    private void lookForGlobalFixture(FunctionDef functionDef) {
        if (functionDef.isMethodDefinition()) {
            return;
        }
        if (functionDef.decorators().stream().anyMatch(NotDiscoverableTestMethodCheck::isPytestFixture)) {
            this.globalFixture.add(functionDef.name().name());
        }
    }

    private static Set<String> getFixturesFromClass(ClassDef classDefinition) {
        return classDefinition.body().statements().stream().filter(statement -> statement.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})).map(FunctionDef.class::cast).filter(functionDef -> functionDef.decorators().stream().anyMatch(NotDiscoverableTestMethodCheck::isPytestFixture)).map(functionDef -> functionDef.name().name()).collect(Collectors.toSet());
    }

    private boolean isException(FunctionDef functionDef, Set<String> classFixtures) {
        String functionName = functionDef.name().name();
        return NotDiscoverableTestMethodCheck.overrideExistingMethod(functionName) || functionName.startsWith("test") || this.isHelper(functionDef, classFixtures);
    }

    private static boolean isPytestFixture(Decorator decorator) {
        String decoratorName = TreeUtils.decoratorNameFromExpression((Expression)decorator.expression());
        return "pytest.fixture".equals(decoratorName);
    }

    private static void checkSuspiciousFunctionsUsages(SubscriptionContext ctx, Map<FunctionSymbol, FunctionDef> suspiciousFunctionsAndDefinitions, Set<Tree> allDefinitions) {
        suspiciousFunctionsAndDefinitions.forEach((s, d) -> {
            List usages = s.usages();
            if (usages.size() == 1 || usages.stream().noneMatch(u -> TreeUtils.firstAncestor((Tree)u.tree(), allDefinitions::contains) != null)) {
                ctx.addIssue((Tree)d.name(), MESSAGE);
            }
        });
    }

    private static boolean inheritsOnlyFromUnitTest(ClassDef classDef) {
        return TreeUtils.getParentClassesFQN((ClassDef)classDef).stream().anyMatch(name -> name.contains("unittest") && name.contains("TestCase")) && Optional.ofNullable(TreeUtils.getClassSymbolFromDef((ClassDef)classDef)).stream().anyMatch(classSym -> classSym.superClasses().size() == 1);
    }

    private static boolean overrideExistingMethod(String functionName) {
        return UnittestUtils.allMethods().contains(functionName) || functionName.startsWith("_");
    }

    private boolean isHelper(FunctionDef functionDef, Set<String> currentClassFixture) {
        return Optional.ofNullable(TreeUtils.getFunctionSymbolFromDef((FunctionDef)functionDef)).stream().anyMatch(functionSymbol -> functionSymbol.hasDecorators() || !functionSymbol.parameters().stream().map(FunctionSymbol.Parameter::name).filter(Objects::nonNull).allMatch(name -> "self".equals(name) || this.globalFixture.contains(name) || currentClassFixture.contains(name)));
    }

    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }
}

