/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

public class CheckUtils {
    private static final List<String> PROTOCOL_LIKE_BASE_TYPES = List.of("typing.Protocol", "zope.interface.Interface");
    private static final List<String> ABC_ABSTRACTMETHOD_DECORATORS = List.of("abstractmethod", "abc.abstractmethod");

    private CheckUtils() {
    }

    public static boolean areEquivalent(@Nullable Tree leftTree, @Nullable Tree rightTree) {
        if (leftTree == rightTree) {
            return true;
        }
        if (leftTree == null || rightTree == null) {
            return false;
        }
        if (leftTree.getKind() != rightTree.getKind() || leftTree.children().size() != rightTree.children().size()) {
            return false;
        }
        if (leftTree.children().isEmpty() && rightTree.children().isEmpty()) {
            return CheckUtils.areLeavesEquivalent(leftTree, rightTree);
        }
        List children1 = leftTree.children();
        List children2 = rightTree.children();
        for (int i = 0; i < children1.size(); ++i) {
            if (CheckUtils.areEquivalent((Tree)children1.get(i), (Tree)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areLeavesEquivalent(Tree leftLeaf, Tree rightLeaf) {
        if (leftLeaf.firstToken() == null && rightLeaf.firstToken() == null) {
            return true;
        }
        return leftLeaf.firstToken().type().equals(PythonTokenType.INDENT) || leftLeaf.firstToken().type().equals(PythonTokenType.DEDENT) || leftLeaf.firstToken().value().equals(rightLeaf.firstToken().value());
    }

    @CheckForNull
    public static ClassDef getParentClassDef(Tree tree) {
        for (Tree current = tree.parent(); current != null; current = current.parent()) {
            if (current.is(new Tree.Kind[]{Tree.Kind.CLASSDEF})) {
                return (ClassDef)current;
            }
            if (!current.is(new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA})) continue;
            return null;
        }
        return null;
    }

    public static boolean classHasInheritance(ClassDef classDef) {
        ArgList argList = classDef.args();
        if (argList == null) {
            return false;
        }
        List arguments = argList.arguments();
        if (arguments.isEmpty()) {
            return false;
        }
        return arguments.size() != 1 || !"object".equals(((Argument)arguments.get(0)).firstToken().value());
    }

    public static boolean containsCallToLocalsFunction(Tree tree) {
        return TreeUtils.hasDescendant((Tree)tree, t -> t.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && CheckUtils.calleeHasNameLocals((CallExpression)t));
    }

    private static boolean calleeHasNameLocals(CallExpression callExpression) {
        Expression callee = callExpression.callee();
        return callee.is(new Tree.Kind[]{Tree.Kind.NAME}) && "locals".equals(((Name)callee).name());
    }

    public static boolean hasStringLiteralValue(Expression expression, String value) {
        return CheckUtils.extractStringLiteral((Tree)expression).map(StringLiteral::trimmedQuotesValue).filter(value::equals).isPresent();
    }

    public static Optional<DictionaryLiteral> extractDict(Tree tree) {
        return CheckUtils.extract(Tree.Kind.DICTIONARY_LITERAL, tree);
    }

    public static Optional<ListLiteral> extractList(Tree tree) {
        return CheckUtils.extract(Tree.Kind.LIST_LITERAL, tree);
    }

    public static Optional<StringLiteral> extractStringLiteral(Tree tree) {
        return CheckUtils.extract(Tree.Kind.STRING_LITERAL, tree);
    }

    public static <T> Optional<T> extract(Tree.Kind kind, Tree tree) {
        Expression assignedValue;
        if (tree.is(new Tree.Kind[]{kind})) {
            return Optional.of(tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NAME}) && (assignedValue = Expressions.singleAssignedValue((Name)tree)) != null && assignedValue.is(new Tree.Kind[]{kind})) {
            return Optional.of(assignedValue);
        }
        return Optional.empty();
    }

    public static boolean isConstant(Expression condition) {
        return CheckUtils.isImmutableConstant(condition) || CheckUtils.isConstantCollectionLiteral(condition);
    }

    public static boolean isImmutableConstant(Expression condition) {
        return TreeUtils.isBooleanLiteral((Tree)condition) || condition.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NONE, Tree.Kind.LAMBDA, Tree.Kind.GENERATOR_EXPR});
    }

    public static boolean isConstantCollectionLiteral(Expression condition) {
        switch (condition.getKind()) {
            case LIST_LITERAL: {
                return CheckUtils.doesNotContainUnpackingExpression(((ListLiteral)condition).elements().expressions());
            }
            case DICTIONARY_LITERAL: {
                return CheckUtils.doesNotContainUnpackingExpression(((DictionaryLiteral)condition).elements());
            }
            case SET_LITERAL: {
                return CheckUtils.doesNotContainUnpackingExpression(((SetLiteral)condition).elements());
            }
            case TUPLE: {
                return CheckUtils.doesNotContainUnpackingExpression(((Tuple)condition).elements());
            }
        }
        return false;
    }

    private static boolean doesNotContainUnpackingExpression(List<? extends Tree> elements) {
        if (elements.isEmpty()) {
            return true;
        }
        return elements.stream().anyMatch(element -> !element.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR}));
    }

    public static boolean isNone(InferredType type) {
        return type.canOnlyBe("NoneType");
    }

    public static boolean mustBeAProtocolLike(ClassDef classDef) {
        ClassSymbol classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef);
        if (classSymbol != null) {
            return PROTOCOL_LIKE_BASE_TYPES.stream().anyMatch(arg_0 -> ((ClassSymbol)classSymbol).isOrExtends(arg_0));
        }
        return false;
    }

    public static boolean isAbstract(FunctionDef funDef) {
        return funDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression((Expression)decorator.expression())).anyMatch(foundDeco -> ABC_ABSTRACTMETHOD_DECORATORS.stream().anyMatch(abcDeco -> abcDeco.equals(foundDeco)));
    }

    public static boolean isEmptyStatement(Statement statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.PASS_STMT}) || statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT}) && CheckUtils.isStringLiteralOrEllipsis((ExpressionStatement)statement);
    }

    private static boolean isStringLiteralOrEllipsis(ExpressionStatement statement) {
        Tree expression = (Tree)statement.expressions().get(0);
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return true;
        }
        return expression.is(new Tree.Kind[]{Tree.Kind.ELLIPSIS});
    }

    public static boolean isSelf(Expression expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && "self".equals(((Name)expression).name());
    }

    @CheckForNull
    public static Symbol findFirstParameterSymbol(FunctionDef functionDef) {
        ParameterList parameters = functionDef.parameters();
        if (parameters == null) {
            return null;
        }
        List params = parameters.nonTuple();
        if (params.isEmpty()) {
            return null;
        }
        Name firstParameterName = ((Parameter)params.get(0)).name();
        if (firstParameterName == null) {
            return null;
        }
        return firstParameterName.symbol();
    }
}

