/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7932")
public class FinallyBlockExitStatementCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_FORMAT = "Remove this %s statement from the finally block.";
    private boolean isPython314OrGreater = false;
    private final Set<Tree> finallyBlocks = new HashSet<Tree>();
    private final Set<Tree> nestedScopes = new HashSet<Tree>();
    private final Set<Tree> loopsInFinally = new HashSet<Tree>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.FINALLY_CLAUSE, this::enterFinallyClause);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, this::enterNestedScope);
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, this::enterNestedScope);
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, this::enterLoop);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::enterLoop);
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, this::checkReturnStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.BREAK_STMT, this::checkBreakStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.CONTINUE_STMT, this::checkContinueStatement);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_314);
    }

    private void enterFinallyClause(SubscriptionContext ctx) {
        FinallyClause finallyClause = (FinallyClause)ctx.syntaxNode();
        this.finallyBlocks.add((Tree)finallyClause);
    }

    private void enterNestedScope(SubscriptionContext ctx) {
        Tree node = ctx.syntaxNode();
        if (this.getEnclosingFinallyBlock(node) != null) {
            this.nestedScopes.add(node);
        }
    }

    private void enterLoop(SubscriptionContext ctx) {
        Tree node = ctx.syntaxNode();
        Tree finallyBlock = this.getEnclosingFinallyBlock(node);
        if (finallyBlock != null && !this.isInsideNestedClassOrFunctionWithinFinally(node, finallyBlock)) {
            this.loopsInFinally.add(node);
        }
    }

    private Tree getEnclosingFinallyBlock(Tree tree) {
        return TreeUtils.firstAncestor((Tree)tree, this.finallyBlocks::contains);
    }

    private boolean isInsideNestedClassOrFunctionWithinFinally(Tree tree, Tree finallyBlock) {
        return this.isInsideAncestorWithinFinally(tree, this.nestedScopes, finallyBlock);
    }

    private void checkReturnStatement(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ReturnStatement returnStmt = (ReturnStatement)ctx.syntaxNode();
        Tree finallyBlock = this.getEnclosingFinallyBlock((Tree)returnStmt);
        if (finallyBlock != null && !this.isInsideNestedClassOrFunctionWithinFinally((Tree)returnStmt, finallyBlock)) {
            ctx.addIssue((Tree)returnStmt, String.format(MESSAGE_FORMAT, "return"));
        }
    }

    private void checkBreakStatement(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        BreakStatement breakStmt = (BreakStatement)ctx.syntaxNode();
        this.raiseIfIsNotInsideNestedClassOrFunctionOrALoop((Tree)breakStmt, "break", ctx);
    }

    private void checkContinueStatement(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ContinueStatement continueStmt = (ContinueStatement)ctx.syntaxNode();
        this.raiseIfIsNotInsideNestedClassOrFunctionOrALoop((Tree)continueStmt, "continue", ctx);
    }

    private void raiseIfIsNotInsideNestedClassOrFunctionOrALoop(Tree statement, String statementType, SubscriptionContext ctx) {
        Tree finallyBlock = this.getEnclosingFinallyBlock(statement);
        if (finallyBlock != null && !this.isInsideNestedClassOrFunctionWithinFinally(statement, finallyBlock) && !this.isInsideLoopWithinFinally(statement, finallyBlock)) {
            ctx.addIssue(statement, String.format(MESSAGE_FORMAT, statementType));
        }
    }

    private boolean isInsideLoopWithinFinally(Tree tree, Tree finallyBlock) {
        return this.isInsideAncestorWithinFinally(tree, this.loopsInFinally, finallyBlock);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInsideAncestorWithinFinally(Tree tree, Set<Tree> ancestors, Tree finallyBlock) {
        Tree ancestor = TreeUtils.firstAncestor((Tree)tree, ancestors::contains);
        if (ancestor == null) return false;
        if (TreeUtils.firstAncestor((Tree)ancestor, finallyBlock::equals) == null) return false;
        return true;
    }
}

