/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S7943")
public class TemplateAndStrConcatenationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Template strings should not be concatenated with regular strings.";
    private boolean isPython314OrGreater = false;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.PLUS, this::checkStringConcatenation);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_314);
    }

    private void checkStringConcatenation(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        Expression leftOperand = binaryExpression.leftOperand();
        Expression rightOperand = binaryExpression.rightOperand();
        if (leftOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && rightOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            boolean isRightTemplate;
            StringLiteral leftString = (StringLiteral)leftOperand;
            StringLiteral rightString = (StringLiteral)rightOperand;
            boolean isLeftTemplate = TemplateAndStrConcatenationCheck.isTemplateString(leftString);
            if (isLeftTemplate != (isRightTemplate = TemplateAndStrConcatenationCheck.isTemplateString(rightString))) {
                ctx.addIssue((Tree)binaryExpression, MESSAGE).secondary((Tree)leftString, isLeftTemplate ? "Template string" : "Regular string").secondary((Tree)rightString, isRightTemplate ? "Template string" : "Regular string");
            }
        }
    }

    private static boolean isTemplateString(StringLiteral stringLiteral) {
        return stringLiteral.stringElements().stream().anyMatch(StringElement::isTemplate);
    }
}

