/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1110")
public class UselessParenthesisCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1110";
    private static final String MESSAGE = "Remove those redundant parentheses.";
    public static final String QUICK_FIX_MESSAGE = "Remove the redundant parentheses";
    private boolean isPython314OrGreater = false;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_314);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.PARENTHESIZED, ctx -> {
            ParenthesizedExpression parenthesized = (ParenthesizedExpression)ctx.syntaxNode();
            Expression expression = parenthesized.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED, Tree.Kind.TUPLE, Tree.Kind.GENERATOR_EXPR}) || this.isPython314OrGreater && UselessParenthesisCheck.isUselessExceptionParentheses(parenthesized)) {
                PythonCheck.PreciseIssue issue = ctx.addIssue(parenthesized.leftParenthesis(), MESSAGE).secondary(parenthesized.rightParenthesis(), null);
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.remove((Tree)parenthesized.leftParenthesis()), TextEditUtils.remove((Tree)parenthesized.rightParenthesis())}).build();
                issue.addQuickFix(quickFix);
            }
        });
    }

    private static boolean isUselessExceptionParentheses(ParenthesizedExpression parenthesized) {
        Tree exceptClause = TreeUtils.firstAncestorOfKind((Tree)parenthesized, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.EXCEPT_GROUP_CLAUSE});
        if (exceptClause == null) {
            return false;
        }
        Expression expression = parenthesized.expression();
        return !expression.is(new Tree.Kind[]{Tree.Kind.TUPLE});
    }
}

