/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7620")
public class AwsLambdaTmpCleanupCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Clean up this temporary file before the Lambda function completes.";
    private static final String SECONDARY_LOCATION_MESSAGE = "The temporary folder is used in this Lambda function.";
    private static final Pattern TMP_PATH_PATTERN = Pattern.compile("^/tmp/.*");
    private TypeCheckBuilder openType;
    private TypeCheckBuilder osRemoveType;
    private TypeCheckBuilder osUnlinkType;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::visitCallExpression);
    }

    private void initializeTypeChecker(SubscriptionContext ctx) {
        this.openType = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("open");
        this.osRemoveType = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("os.remove");
        this.osUnlinkType = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("os.unlink");
    }

    private void visitCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Tree functionDefAncestor = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
        if (functionDefAncestor == null) {
            return;
        }
        FunctionDef lambdaHandler = (FunctionDef)functionDefAncestor;
        if (!AwsLambdaChecksUtils.isLambdaHandler(ctx, lambdaHandler)) {
            return;
        }
        if (this.openType.check(callExpression.callee().typeV2()).isTrue() && !this.isTempFileCleanedUp(callExpression, lambdaHandler)) {
            ctx.addIssue((Tree)callExpression.callee(), MESSAGE).secondary((Tree)lambdaHandler.name(), SECONDARY_LOCATION_MESSAGE);
        }
    }

    private boolean isTempFileCleanedUp(CallExpression callExpression, FunctionDef lambdaHandler) {
        RegularArgument regularArg = TreeUtils.nthArgumentOrKeyword((int)0, (String)"file", (List)callExpression.arguments());
        if (regularArg == null) {
            return true;
        }
        Expression pathExpression = regularArg.expression();
        String pathValue = AwsLambdaTmpCleanupCheck.getStringValue(pathExpression);
        return pathValue == null || !TMP_PATH_PATTERN.matcher(pathValue).matches() || this.hasCleanupCall(lambdaHandler, pathValue) || this.isPathPassedToOtherFunction(pathExpression);
    }

    private boolean isPathPassedToOtherFunction(Expression pathExpression) {
        if (!(pathExpression instanceof Name)) {
            return true;
        }
        Name name = (Name)pathExpression;
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return true;
        }
        return AwsLambdaTmpCleanupCheck.getUsagesInCallExpr(symbol).anyMatch(callExpr -> !this.isOsRemoveOrUnlinkCall((CallExpression)callExpr) && !this.openType.check(callExpr.callee().typeV2()).isTrue());
    }

    private static Stream<CallExpression> getUsagesInCallExpr(SymbolV2 symbol) {
        return symbol.usages().stream().filter(usage -> usage.kind().equals((Object)UsageV2.Kind.OTHER)).map(usage -> usage.tree().parent()).filter(parent -> parent.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(parent -> TreeUtils.firstAncestorOfKind((Tree)parent, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR})).flatMap(TreeUtils.toStreamInstanceOfMapper(CallExpression.class));
    }

    private boolean hasCleanupCall(FunctionDef function, String filePath) {
        return TreeUtils.firstChild((Tree)function, child -> {
            CallExpression callExpr;
            return child instanceof CallExpression && this.isOsRemoveOrUnlinkCall(callExpr = (CallExpression)child) && AwsLambdaTmpCleanupCheck.hasMatchingPath(callExpr, filePath);
        }).isPresent();
    }

    private boolean isOsRemoveOrUnlinkCall(CallExpression callExpression) {
        return this.osRemoveType.check(callExpression.callee().typeV2()).isTrue() || this.osUnlinkType.check(callExpression.callee().typeV2()).isTrue();
    }

    private static boolean hasMatchingPath(CallExpression call, String targetPath) {
        RegularArgument regularArg = TreeUtils.nthArgumentOrKeyword((int)0, (String)"path", (List)call.arguments());
        if (regularArg == null) {
            return false;
        }
        String pathValue = AwsLambdaTmpCleanupCheck.getStringValue(regularArg.expression());
        return targetPath.equals(pathValue);
    }

    @Nullable
    private static String getStringValue(Expression expression) {
        Name name;
        Expression assignedValue;
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            return stringLiteral.trimmedQuotesValue();
        }
        if (expression instanceof Name && (assignedValue = Expressions.singleAssignedValue(name = (Name)expression)) instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)assignedValue;
            return stringLiteral.trimmedQuotesValue();
        }
        return null;
    }
}

