/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5704")
public class BareRaiseInFinallyCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (!raiseStatement.expressions().isEmpty()) {
                return;
            }
            if (BareRaiseInFinallyCheck.isWithinExceptClause(raiseStatement) || BareRaiseInFinallyCheck.isWithinExitFunction(raiseStatement)) {
                return;
            }
            Tree parent = TreeUtils.firstAncestorOfKind((Tree)raiseStatement, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FINALLY_CLAUSE, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
            if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.FINALLY_CLAUSE})) {
                ctx.addIssue((Tree)raiseStatement, "Refactor this code so that any active exception raises naturally.");
            }
        });
    }

    private static boolean isWithinExceptClause(RaiseStatement raiseStatement) {
        Tree tree = TreeUtils.firstAncestorOfKind((Tree)raiseStatement, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
        return tree != null && tree.is(new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE});
    }

    private static boolean isWithinExitFunction(RaiseStatement finallyClause) {
        return TreeUtils.firstAncestor((Tree)finallyClause, t -> t.is(new Tree.Kind[]{Tree.Kind.FUNCDEF}) && "__exit__".equals(((FunctionDef)t).name().name())) != null;
    }
}

