/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S6796")
public class GenericFunctionTypeParameterCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a generic type parameter for this function instead of a \"TypeVar\".";
    private static final String SECONDARY_MESSAGE_USE = "Use of \"TypeVar\" here.";
    private static final String SECONDARY_MESSAGE_ASSIGNMENT = "\"TypeVar\" is assigned here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, GenericFunctionTypeParameterCheck::checkUseOfGenerics);
    }

    private static void checkUseOfGenerics(SubscriptionContext ctx) {
        if (!GenericFunctionTypeParameterCheck.supportsTypeParameterSyntax(ctx)) {
            return;
        }
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        Set<Tree> secondaryLocations = Optional.ofNullable(functionDef.parameters()).map(ParameterList::nonTuple).stream().flatMap(Collection::stream).map(Parameter::typeAnnotation).filter(Objects::nonNull).map(TypeAnnotation::expression).filter(Expressions::isGenericTypeAnnotation).collect(Collectors.toSet());
        Optional.ofNullable(functionDef.returnTypeAnnotation()).map(TypeAnnotation::expression).filter(Expressions::isGenericTypeAnnotation).ifPresent(secondaryLocations::add);
        if (!secondaryLocations.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)functionDef.name(), MESSAGE);
            secondaryLocations.forEach(loc -> issue.secondary(loc, SECONDARY_MESSAGE_USE));
            GenericFunctionTypeParameterCheck.getAssignmentLocations(secondaryLocations).forEach(loc -> issue.secondary(loc, SECONDARY_MESSAGE_ASSIGNMENT));
        }
    }

    private static Set<Tree> getAssignmentLocations(Set<Tree> secondaryLocations) {
        return secondaryLocations.stream().map(Name.class::cast).map(Expressions::singleAssignedValue).collect(Collectors.toSet());
    }

    private static boolean supportsTypeParameterSyntax(SubscriptionContext ctx) {
        return PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_312);
    }
}

