/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonLine;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S139")
public class TrailingCommentCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^#\\s*+([^\\s]++|fmt.*|type.*|noqa.*)$";
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    @RuleProperty(key="legalTrailingCommentPattern", description="Pattern for text of trailing comments that are allowed. By default, Mypy and Black pragma comments as well as comments containing only one word.", defaultValue="^#\\s*+([^\\s]++|fmt.*|type.*|noqa.*)$")
    public String legalCommentPattern = "^#\\s*+([^\\s]++|fmt.*|type.*|noqa.*)$";
    private int previousTokenLine;
    private List<String> lines;

    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(this.legalCommentPattern);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.previousTokenLine = -1;
            this.lines = null;
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                String comment;
                Token commentToken = trivia.token();
                if (this.previousTokenLine != commentToken.line() || pattern.matcher(comment = commentToken.value()).matches()) continue;
                PythonCheck.PreciseIssue issue = ctx.addIssue(commentToken, MESSAGE);
                String line = this.getLines((SubscriptionContext)ctx).get(commentToken.pythonLine().line() - 1);
                TrailingCommentCheck.addQuickFix(issue, commentToken, line);
            }
            this.previousTokenLine = token.line();
        });
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Token commentToken, String line) {
        String indent = TrailingCommentCheck.calculateIndent(line);
        PythonTextEdit insertComment = TextEditUtils.insertAtPosition((PythonLine)commentToken.pythonLine(), (int)0, (String)(indent + commentToken.value() + "\n"));
        int startColumnRemove = TrailingCommentCheck.calculateStartColumnToRemove(commentToken, line);
        PythonTextEdit removeTrailingComment = TextEditUtils.removeRange((PythonLine)commentToken.pythonLine(), (int)startColumnRemove, (PythonLine)commentToken.pythonLine(), (int)line.length());
        PythonQuickFix fix = PythonQuickFix.newQuickFix((String)MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{removeTrailingComment, insertComment});
        issue.addQuickFix(fix);
    }

    private static String calculateIndent(String line) {
        String lineWithoutIndent = line.stripLeading();
        int column = line.indexOf(lineWithoutIndent);
        return " ".repeat(column);
    }

    private List<String> getLines(SubscriptionContext ctx) {
        if (this.lines == null) {
            this.lines = ctx.pythonFile().content().lines().toList();
        }
        return this.lines;
    }

    private static int calculateStartColumnToRemove(Token commentToken, String line) {
        return line.substring(0, commentToken.pythonColumn()).stripTrailing().length();
    }
}

