/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7618")
public class NetworkCallsWithoutTimeoutsInLambdaCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Set an explicit timeout for this network call to prevent hanging executions in Lambda functions.";
    private static final int BOTO3_CLIENT_RESOURCE_CONFIG_NTH_ARGUMENT = 9;
    private static final Set<String> REQUESTS_METHODS = Set.of("get", "post", "put", "delete", "head", "options", "patch", "request");
    private static final Set<String> BOTO3_ENTRY_FUNCTIONS = Set.of("boto3.client", "boto3.resource", "boto3.session.Session.client", "boto3.session.Session.resource");
    private TypeCheckMap<Object> requestsTypeChecks;
    private TypeCheckMap<Object> boto3EntryFunctionTypeChecks;
    private TypeCheckBuilder configConstructorTypeCheck;
    private boolean isLambdaHandlerInThisFile = false;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckMaps);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkNetworkCall);
    }

    private void initializeTypeCheckMaps(SubscriptionContext ctx) {
        this.isLambdaHandlerInThisFile = AwsLambdaChecksUtils.isLambdaHandlerInThisFile(ctx, ctx.syntaxNode());
        this.requestsTypeChecks = new TypeCheckMap();
        Object marker = new Object();
        for (String method : REQUESTS_METHODS) {
            this.requestsTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeWithName("requests." + method), marker);
            this.requestsTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeWithName("requests.sessions.Session." + method), marker);
        }
        this.boto3EntryFunctionTypeChecks = new TypeCheckMap();
        for (String entryFunction : BOTO3_ENTRY_FUNCTIONS) {
            this.boto3EntryFunctionTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeWithName(entryFunction), marker);
        }
        this.configConstructorTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("botocore.config.Config");
    }

    private void checkNetworkCall(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (!this.isLambdaHandlerInThisFile) {
            return;
        }
        this.checkRequestsCall(ctx, callExpression);
        this.checkBoto3Call(ctx, callExpression);
    }

    private void checkRequestsCall(SubscriptionContext ctx, CallExpression callExpression) {
        PythonType type = callExpression.callee().typeV2();
        if (this.requestsTypeChecks.getOptionalForType(type).isPresent()) {
            NetworkCallsWithoutTimeoutsInLambdaCheck.checkTimeoutParameter(ctx, callExpression);
        }
    }

    private static void checkTimeoutParameter(SubscriptionContext ctx, CallExpression callExpression) {
        Optional<CdkUtils.ExpressionFlow> timeoutArg = CdkUtils.getArgument(ctx, callExpression, "timeout");
        if (timeoutArg.isEmpty()) {
            ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
        } else {
            timeoutArg.get().addIssueIf(CdkPredicate.isNone(), MESSAGE, callExpression);
        }
    }

    private void checkBoto3Call(SubscriptionContext ctx, CallExpression callExpression) {
        PythonType type = callExpression.callee().typeV2();
        if (!this.isBoto3ClientOrResource(type)) {
            return;
        }
        RegularArgument configArg = NetworkCallsWithoutTimeoutsInLambdaCheck.getBotocoreConfigArgument(callExpression);
        if (configArg == null) {
            ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
        } else {
            CallExpression configConstructor = NetworkCallsWithoutTimeoutsInLambdaCheck.getConfigArgumentConstructorCallExpr(configArg);
            if (configConstructor != null && this.isInvalidConfigConstructorCall(configConstructor)) {
                ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
            }
        }
    }

    private boolean isBoto3ClientOrResource(PythonType type) {
        return this.boto3EntryFunctionTypeChecks.getOptionalForType(type).isPresent();
    }

    @CheckForNull
    private static RegularArgument getBotocoreConfigArgument(CallExpression callExpression) {
        return TreeUtils.nthArgumentOrKeyword((int)9, (String)"config", (List)callExpression.arguments());
    }

    @CheckForNull
    private static CallExpression getConfigArgumentConstructorCallExpr(RegularArgument arg) {
        Expression argExpr = arg.expression();
        if (argExpr instanceof Name) {
            Name argName = (Name)argExpr;
            return NetworkCallsWithoutTimeoutsInLambdaCheck.getSingleAssignedConfigConstructorCallExpr(argName).orElse(null);
        }
        if (argExpr instanceof CallExpression) {
            CallExpression callExpr = (CallExpression)argExpr;
            return callExpr;
        }
        return null;
    }

    private static Optional<CallExpression> getSingleAssignedConfigConstructorCallExpr(Name configVarName) {
        return Expressions.singleAssignedNonNameValue(configVarName).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class));
    }

    private boolean isInvalidConfigConstructorCall(CallExpression callExpression) {
        return this.configConstructorTypeCheck.check(callExpression.callee().typeV2()).isTrue() && !NetworkCallsWithoutTimeoutsInLambdaCheck.hasArgumentWithName(callExpression, "read_timeout") && !NetworkCallsWithoutTimeoutsInLambdaCheck.hasArgumentWithName(callExpression, "connect_timeout");
    }

    private static boolean hasArgumentWithName(CallExpression callExpression, String name) {
        return TreeUtils.argumentByKeyword((String)name, (List)callExpression.arguments()) != null;
    }
}

