/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

public abstract class AbstractCookieFlagCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
            AbstractCookieFlagCheck.getSubscriptionToCookies(assignment.lhsExpressions()).forEach(sub -> {
                if (AbstractCookieFlagCheck.isSettingFlag(sub, this.flagName()) && Expressions.isFalsy(assignment.assignedValue())) {
                    ctx.addIssue((Tree)assignment, this.message());
                }
            });
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            this.verifyCallExpression((SubscriptionContext)ctx, callExpression);
        });
    }

    private void verifyCallExpression(SubscriptionContext ctx, CallExpression callExpression) {
        if (callExpression.arguments().stream().anyMatch(argument -> argument.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR}))) {
            return;
        }
        MethodArgumentsToCheckRegistry registry = this.methodArgumentsToCheckRegistry();
        String methodName = AbstractCookieFlagCheck.getCallExpressionMethodName(callExpression);
        String methodFqn = AbstractCookieFlagCheck.getCallExpressionMethodFqn(callExpression);
        if (methodName != null && registry.hasMethodName(methodName) || methodFqn != null && registry.hasMethodFqn(methodFqn)) {
            this.findMethodArgumentToCheck(callExpression, methodFqn, methodName).ifPresent(methodArgumentsToCheck -> {
                RegularArgument argument = TreeUtils.nthArgumentOrKeyword((int)methodArgumentsToCheck.argumentPosition(), (String)methodArgumentsToCheck.argumentName(), (List)callExpression.arguments());
                if (methodArgumentsToCheck.invalidArgumentPredicate().test(argument)) {
                    ctx.addIssue((Tree)callExpression.callee(), this.message());
                }
            });
        }
    }

    private Optional<MethodArgumentsToCheck> findMethodArgumentToCheck(CallExpression callExpression, @Nullable String methodFqn, @Nullable String methodName) {
        return Optional.ofNullable(methodFqn).map(this.methodArgumentsToCheckRegistry()::getByMethodFqn).or(() -> Optional.ofNullable(methodName).map(this.methodArgumentsToCheckRegistry()::getByMethodName).stream().flatMap(Collection::stream).filter(methodArgumentsToCheck -> AbstractCookieFlagCheck.canBeOrExtendMatches(callExpression, methodArgumentsToCheck)).findFirst());
    }

    private static Boolean canBeOrExtendMatches(CallExpression callExpression, MethodArgumentsToCheck methodArgumentsToCheck) {
        return Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::qualifier).map(Expression::type).map(t -> t.mustBeOrExtend(methodArgumentsToCheck.calleeFqn())).orElse(false);
    }

    private static String getCallExpressionMethodName(CallExpression callExpression) {
        return Optional.of(callExpression).map(CallExpression::calleeSymbol).map(Symbol::name).orElse(null);
    }

    private static String getCallExpressionMethodFqn(CallExpression callExpression) {
        return Optional.of(callExpression).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).orElse(null);
    }

    private static Stream<SubscriptionExpression> getSubscriptionToCookies(List<ExpressionList> lhsExpressions) {
        return lhsExpressions.stream().flatMap(expressionList -> expressionList.expressions().stream()).filter(lhs -> {
            if (lhs.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
                SubscriptionExpression sub = (SubscriptionExpression)lhs;
                return AbstractCookieFlagCheck.getObject(sub.object()).type().canOnlyBe("http.cookies.SimpleCookie");
            }
            return false;
        }).map(SubscriptionExpression.class::cast);
    }

    private static boolean isSettingFlag(SubscriptionExpression sub, String flagName) {
        List<ExpressionList> subscripts = AbstractCookieFlagCheck.getSubscripts(sub);
        if (subscripts.size() == 1) {
            return false;
        }
        return subscripts.stream().skip(1L).anyMatch(s -> s.expressions().size() == 1 && AbstractCookieFlagCheck.isFlagNameStringLiteral((Expression)s.expressions().get(0), flagName));
    }

    private static List<ExpressionList> getSubscripts(SubscriptionExpression sub) {
        ArrayDeque<ExpressionList> subscripts = new ArrayDeque<ExpressionList>();
        subscripts.addFirst(sub.subscripts());
        Expression object = sub.object();
        while (object.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            subscripts.addFirst(((SubscriptionExpression)object).subscripts());
            object = ((SubscriptionExpression)object).object();
        }
        return new ArrayList<ExpressionList>(subscripts);
    }

    private static boolean isFlagNameStringLiteral(Expression expression, String value) {
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && ((StringLiteral)expression).trimmedQuotesValue().equalsIgnoreCase(value);
    }

    private static Expression getObject(Expression object) {
        if (object.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            return AbstractCookieFlagCheck.getObject(((SubscriptionExpression)object).object());
        }
        return object;
    }

    protected boolean isInvalidHeaderArgument(@Nullable RegularArgument argument) {
        return Optional.ofNullable(argument).map(RegularArgument::expression).map(this::isDictWithSensitiveEntry).orElse(false);
    }

    private boolean isDictWithSensitiveEntry(Expression expression) {
        return TreeUtils.toOptionalInstanceOf(Name.class, (Tree)expression).flatMap(Expressions::singleAssignedNonNameValue).map(this::isDictWithSensitiveEntry).or(() -> TreeUtils.toOptionalInstanceOf(DictionaryLiteral.class, (Tree)expression).map(this::hasInvalidEntry)).orElse(false);
    }

    private boolean hasInvalidEntry(DictionaryLiteral dictionaryLiteral) {
        return dictionaryLiteral.elements().stream().filter(KeyValuePair.class::isInstance).map(KeyValuePair.class::cast).filter(keyValuePair -> AbstractCookieFlagCheck.isSensitiveKey(keyValuePair.key())).map(KeyValuePair::value).anyMatch(this::invalidValue);
    }

    private static boolean isSensitiveKey(Expression key) {
        return TreeUtils.toOptionalInstanceOf(StringLiteral.class, (Tree)key).map(StringLiteral::trimmedQuotesValue).filter("set-cookie"::equalsIgnoreCase).isPresent();
    }

    private boolean invalidValue(Expression value) {
        return TreeUtils.toOptionalInstanceOf(StringLiteral.class, (Tree)value).map(StringLiteral::trimmedQuotesValue).filter(Predicate.not(val -> val.matches(this.headerValueRegex()))).isPresent();
    }

    protected abstract String headerValueRegex();

    abstract String flagName();

    abstract String message();

    abstract MethodArgumentsToCheckRegistry methodArgumentsToCheckRegistry();

    static class MethodArgumentsToCheckRegistry {
        private final Map<String, List<MethodArgumentsToCheck>> byMethodName;
        private final Map<String, MethodArgumentsToCheck> byMethodFqn;

        public MethodArgumentsToCheckRegistry(MethodArgumentsToCheck ... arguments) {
            this.byMethodName = Stream.of(arguments).filter(argument -> Objects.nonNull(argument.methodName)).collect(Collectors.groupingBy(MethodArgumentsToCheck::methodName));
            this.byMethodFqn = Stream.of(arguments).collect(Collectors.toMap(MethodArgumentsToCheck::methodFqn, Function.identity(), (v1, v2) -> v2));
        }

        List<MethodArgumentsToCheck> getByMethodName(String methodName) {
            return this.byMethodName.get(methodName);
        }

        MethodArgumentsToCheck getByMethodFqn(String methodFqn) {
            return this.byMethodFqn.get(methodFqn);
        }

        boolean hasMethodName(String methodName) {
            return this.byMethodName.containsKey(methodName);
        }

        boolean hasMethodFqn(String methodFqn) {
            return this.byMethodFqn.containsKey(methodFqn);
        }
    }

    static class MethodArgumentsToCheck {
        private final String calleeFqn;
        private final String methodName;
        private final String methodFqn;
        private final String argumentName;
        private final int argumentPosition;
        private final Predicate<RegularArgument> invalidArgumentPredicate;

        public MethodArgumentsToCheck(String calleeFqn, String argumentName, int argumentPosition, Predicate<RegularArgument> invalidArgumentPredicate) {
            this(calleeFqn, null, argumentName, argumentPosition, invalidArgumentPredicate);
        }

        public MethodArgumentsToCheck(String calleeFqn, String methodName, String argumentName, int argumentPosition) {
            this(calleeFqn, methodName, argumentName, argumentPosition, arg -> arg == null || Expressions.isFalsy(arg.expression()));
        }

        public MethodArgumentsToCheck(String calleeFqn, @Nullable String methodName, String argumentName, int argumentPosition, Predicate<RegularArgument> invalidArgumentPredicate) {
            this.calleeFqn = calleeFqn;
            this.methodName = methodName;
            this.invalidArgumentPredicate = invalidArgumentPredicate;
            this.methodFqn = Optional.ofNullable(methodName).map(mn -> calleeFqn + "." + mn).orElse(calleeFqn);
            this.argumentName = argumentName;
            this.argumentPosition = argumentPosition;
        }

        public String calleeFqn() {
            return this.calleeFqn;
        }

        public String methodName() {
            return this.methodName;
        }

        public String argumentName() {
            return this.argumentName;
        }

        public int argumentPosition() {
            return this.argumentPosition;
        }

        public String methodFqn() {
            return this.methodFqn;
        }

        public Predicate<RegularArgument> invalidArgumentPredicate() {
            return this.invalidArgumentPredicate;
        }
    }
}

