/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1607")
public class SkippedTestNoReasonCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Provide a reason for skipping this test.";
    private static final Set<String> skipDecoratorsFQN = new HashSet<String>(List.of("unittest.case.skip", "pytest.mark.skip"));
    private static final Set<String> skipCallExpressionsFQN = new HashSet<String>(List.of("pytest.skip"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.DECORATOR, ctx -> {
            Decorator decorator = (Decorator)ctx.syntaxNode();
            SkippedTestNoReasonCheck.checkDecoratorSkipWithoutReason(ctx, decorator);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            SkippedTestNoReasonCheck.checkCallExpressionSkipWithNoOrEmptyReason(ctx, callExpression);
        });
    }

    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }

    private static void checkDecoratorSkipWithoutReason(SubscriptionContext ctx, Decorator decorator) {
        Expression expression = decorator.expression();
        Symbol symbol = SkippedTestNoReasonCheck.getSymbolFromExpression(expression);
        if (symbol == null) {
            return;
        }
        if (!skipDecoratorsFQN.contains(symbol.fullyQualifiedName())) {
            return;
        }
        SkippedTestNoReasonCheck.checkNoOrEmptyReason(ctx, (Tree)decorator, decorator.arguments());
    }

    private static Symbol getSymbolFromExpression(Expression expression) {
        if (expression instanceof HasSymbol) {
            HasSymbol hasSymbol = (HasSymbol)expression;
            return hasSymbol.symbol();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return ((CallExpression)expression).calleeSymbol();
        }
        return null;
    }

    private static void checkCallExpressionSkipWithNoOrEmptyReason(SubscriptionContext ctx, CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol == null) {
            return;
        }
        if (!skipCallExpressionsFQN.contains(symbol.fullyQualifiedName())) {
            return;
        }
        SkippedTestNoReasonCheck.checkNoOrEmptyReason(ctx, (Tree)callExpression, callExpression.argumentList());
    }

    private static void checkNoOrEmptyReason(SubscriptionContext ctx, Tree node, ArgList args) {
        if (args == null) {
            ctx.addIssue(node, MESSAGE);
            return;
        }
        Argument arg = (Argument)args.arguments().get(0);
        if (!arg.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            return;
        }
        RegularArgument regularArg = (RegularArgument)arg;
        if (!regularArg.expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return;
        }
        StringLiteral stringLiteral = (StringLiteral)regularArg.expression();
        if (stringLiteral.trimmedQuotesValue().isEmpty()) {
            ctx.addIssue((Tree)stringLiteral, MESSAGE);
        }
    }
}

