/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7622")
public class AwsMissingPaginationCheck
extends PythonSubscriptionCheck {
    private static final Set<String> SENSITIVE_METHODS_FQNS = Set.of("botocore.client.BaseClient.list_objects_v2", "botocore.client.BaseClient.scan");
    private TypeCheckMap<Boolean> sensitiveTypesCheckMap;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initializeCheck(SubscriptionContext ctx) {
        this.sensitiveTypesCheckMap = new TypeCheckMap();
        SENSITIVE_METHODS_FQNS.stream().map(fqn -> ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(fqn)).forEach(check -> this.sensitiveTypesCheckMap.put(check, (Object)true));
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.sensitiveTypesCheckMap.containsForType(TreeUtils.inferSingleAssignedExpressionType((Expression)callExpression.callee()))) {
            ctx.addIssue((Tree)callExpression, "Use a paginator to retrieve all results from this boto3 operation.");
        }
    }
}

