/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7945")
public class TemplateStringStructuralPatternMatchingCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use structural pattern matching (match/case) instead of isinstance() checks for template string processing.";
    private static final String SECONDARY_MESSAGE = "Replace this isinstance with the appropriate pattern matching case.";
    private TypeCheckMap<Object> templateType = new TypeCheckMap();
    private TypeCheckBuilder isInstanceCheck;
    private boolean isPython314OrGreater;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::checkForStatement);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.isInstanceCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("isinstance");
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan((Set)ctx.sourcePythonVersions(), (PythonVersionUtils.Version)PythonVersionUtils.Version.V_314);
        Object marker = new Object();
        this.templateType.put(ctx.typeChecker().typeCheckBuilder().isTypeWithName("str"), marker);
        this.templateType.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("string.templatelib.Interpolation"), marker);
    }

    private void checkForStatement(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ForStatement forStmt = (ForStatement)ctx.syntaxNode();
        StatementList body = forStmt.body();
        if (body == null || body.statements().isEmpty()) {
            return;
        }
        List<String> iterationVariables = TemplateStringStructuralPatternMatchingCheck.extractIterationVariables(forStmt.expressions());
        if (iterationVariables.isEmpty()) {
            return;
        }
        List<IsInstanceCallAndType> isInstanceChecks = this.findIsInstanceChecks(body.statements(), iterationVariables);
        if (isInstanceChecks.size() >= 2 && this.hasTemplateTypeChecks(isInstanceChecks)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)isInstanceChecks.get((int)0).callExpr.callee(), MESSAGE);
            isInstanceChecks.stream().skip(1L).forEach(isInstance -> issue.secondary((Tree)isInstance.callExpr.callee(), SECONDARY_MESSAGE));
        }
    }

    private static List<String> extractIterationVariables(List<Expression> expressions) {
        ArrayList<String> variables = new ArrayList<String>();
        for (Expression expr : expressions) {
            if (!(expr instanceof Name)) continue;
            Name name = (Name)expr;
            variables.add(name.name());
        }
        return variables;
    }

    private List<IsInstanceCallAndType> findIsInstanceChecks(List<Statement> statements, List<String> iterationVariables) {
        ArrayList<IsInstanceCallAndType> isInstanceChecks = new ArrayList<IsInstanceCallAndType>();
        for (Statement stmt : statements) {
            if (!(stmt instanceof IfStatement)) continue;
            IfStatement ifStmt = (IfStatement)stmt;
            isInstanceChecks.addAll(this.extractIsInstanceChecks(ifStmt.condition(), iterationVariables));
            for (IfStatement elif : ifStmt.elifBranches()) {
                isInstanceChecks.addAll(this.extractIsInstanceChecks(elif.condition(), iterationVariables));
            }
            ElseClause elseClause = ifStmt.elseBranch();
            if (elseClause == null || elseClause.body() == null) continue;
            isInstanceChecks.addAll(this.findIsInstanceChecks(elseClause.body().statements(), iterationVariables));
        }
        return isInstanceChecks;
    }

    private List<IsInstanceCallAndType> extractIsInstanceChecks(Expression condition, List<String> iterationVariables) {
        ArrayList<IsInstanceCallAndType> checks = new ArrayList<IsInstanceCallAndType>();
        if (condition instanceof CallExpression) {
            CallExpression callExpr = (CallExpression)condition;
            this.isIsInstanceCheck(callExpr, iterationVariables).ifPresent(checks::add);
        } else if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)condition;
            checks.addAll(this.extractIsInstanceChecks(binaryExpr.leftOperand(), iterationVariables));
            checks.addAll(this.extractIsInstanceChecks(binaryExpr.rightOperand(), iterationVariables));
        }
        return checks;
    }

    private Optional<IsInstanceCallAndType> isIsInstanceCheck(CallExpression callExpr, List<String> iterationVariables) {
        if (!this.isInstanceCheck.check(callExpr.callee().typeV2()).isTrue()) {
            return Optional.empty();
        }
        List<RegularArgument> args = callExpr.arguments().stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(RegularArgument.class::cast).toList();
        if (args.size() != 2) {
            return Optional.empty();
        }
        Expression firstArg = args.get(0).expression();
        if (!(firstArg instanceof Name)) {
            return Optional.empty();
        }
        Name varName = (Name)firstArg;
        if (!iterationVariables.contains(varName.name())) {
            return Optional.empty();
        }
        Expression secondArg = args.get(1).expression();
        if (!(secondArg instanceof Name)) {
            return Optional.empty();
        }
        Name typeName = (Name)secondArg;
        return Optional.of(new IsInstanceCallAndType(callExpr, typeName));
    }

    private boolean hasTemplateTypeChecks(List<IsInstanceCallAndType> isInstanceChecks) {
        long templateTypeCount = isInstanceChecks.stream().map(instanceCallAndType -> instanceCallAndType.typeName.typeV2()).filter(arg_0 -> this.templateType.containsForType(arg_0)).count();
        return templateTypeCount >= 2L;
    }

    private record IsInstanceCallAndType(CallExpression callExpr, Name typeName) {
    }
}

