/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7504")
public class UnnecessaryListCastCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isListCallCheck;
    private static final Set<String> MODIFYING_LIST_METHODS = Set.of("append", "extend", "insert", "remove", "pop", "clear", "sort", "reverse");
    private TypeCheckMap<Object> typeCheckMap;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::checkForStatements);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, this::checkComprehensions);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isListCallCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("list");
        Object marker = new Object();
        this.typeCheckMap = new TypeCheckMap();
        MODIFYING_LIST_METHODS.forEach(method -> {
            TypeCheckBuilder checker = ctx.typeChecker().typeCheckBuilder().isTypeWithName("list." + method);
            this.typeCheckMap.put(checker, marker);
        });
    }

    private void checkForStatements(SubscriptionContext ctx) {
        ForStatement stmt = (ForStatement)ctx.syntaxNode();
        this.hasListCallOnIterable(stmt.testExpressions()).filter(listCall -> !this.isListModifiedInLoop((CallExpression)listCall, stmt)).ifPresent(listCall -> UnnecessaryListCastCheck.raiseIssue(ctx, listCall));
    }

    private void checkComprehensions(SubscriptionContext ctx) {
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        this.hasListCallOnIterable(List.of(comprehensionFor.iterable())).ifPresent(listCall -> UnnecessaryListCastCheck.raiseIssue(ctx, listCall));
    }

    private Optional<CallExpression> hasListCallOnIterable(List<Expression> testExpressions) {
        CallExpression callExpression;
        Expression expression;
        if (testExpressions.size() == 1 && (expression = testExpressions.get(0)) instanceof CallExpression && this.isListCall(callExpression = (CallExpression)expression) && UnnecessaryListCastCheck.getFirstRegularArgument(callExpression).isPresent()) {
            return Optional.of(callExpression);
        }
        return Optional.empty();
    }

    private boolean isListCall(CallExpression callExpression) {
        return this.isListCallCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private boolean isListModifiedInLoop(CallExpression callExpression, ForStatement forStatement) {
        Optional<Name> listName = UnnecessaryListCastCheck.getFirstNameArgument(callExpression);
        return listName.map(name -> {
            ModifyingListMethodTreeVisitor visitor = new ModifyingListMethodTreeVisitor((Name)name, this.typeCheckMap);
            forStatement.accept((TreeVisitor)visitor);
            return visitor.isModifyingListMethod();
        }).orElse(false);
    }

    public static Optional<Name> getFirstNameArgument(CallExpression callExpression) {
        return UnnecessaryListCastCheck.getFirstRegularArgument(callExpression).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class));
    }

    private static Optional<RegularArgument> getFirstRegularArgument(CallExpression callExpression) {
        Object e;
        if (callExpression.arguments().size() == 1 && (e = callExpression.arguments().get(0)) instanceof RegularArgument) {
            RegularArgument regularArgument = (RegularArgument)e;
            return Optional.of(regularArgument);
        }
        return Optional.empty();
    }

    private static void raiseIssue(SubscriptionContext ctx, CallExpression listCall) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)listCall.callee(), "Remove this unnecessary `list()` call on an already iterable object.");
        Optional.ofNullable(listCall.argumentList()).map(argList -> TreeUtils.treeToString((Tree)argList, (boolean)false)).map(replacementText -> TextEditUtils.replace((Tree)listCall, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)"Remove the \"list\" call", (PythonTextEdit[])new PythonTextEdit[]{textEdit})).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
    }

    private static class ModifyingListMethodTreeVisitor
    extends BaseTreeVisitor {
        private final Name listName;
        private final TypeCheckMap<Object> modifyingListTypeCheckMap;
        private boolean isModifyingListMethod = false;

        ModifyingListMethodTreeVisitor(Name listName, TypeCheckMap<Object> modifyingListTypeCheckMap) {
            this.listName = listName;
            this.modifyingListTypeCheckMap = modifyingListTypeCheckMap;
        }

        public boolean isModifyingListMethod() {
            return this.isModifyingListMethod;
        }

        public void visitCallExpression(CallExpression callExpr) {
            super.visitCallExpression(callExpr);
            SymbolV2 symbol = this.listName.symbolV2();
            if (symbol != null) {
                this.isModifyingListMethod |= ModifyingListMethodTreeVisitor.isMethodReceiverInstanceOf(callExpr, symbol) && this.isModifyingListMethod(callExpr);
            }
        }

        private static boolean isMethodReceiverInstanceOf(CallExpression callExpr, SymbolV2 listSymbol) {
            QualifiedExpression qualifiedExpression;
            Expression expression = callExpr.callee();
            if (expression instanceof QualifiedExpression && (expression = (qualifiedExpression = (QualifiedExpression)expression).qualifier()) instanceof Name) {
                Name name = (Name)expression;
                SymbolV2 symbolV2 = name.symbolV2();
                return symbolV2 != null && symbolV2.equals(listSymbol);
            }
            return false;
        }

        private boolean isModifyingListMethod(CallExpression callExpression) {
            return this.modifyingListTypeCheckMap.containsForType(callExpression.callee().typeV2());
        }
    }
}

