/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractCdkResourceCheck {
    private static final String SQS_MANAGED_DISABLED_MESSAGE = "Setting \"sqs_managed_sse_enabled\" to \"false\" disables SQS queues encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_sqs.CfnQueue", this::checkCfnQueue);
    }

    protected void checkCfnQueue(SubscriptionContext ctx, CallExpression resourceConstructor) {
        CdkUtils.getArgument(ctx, resourceConstructor, "sqs_managed_sse_enabled").ifPresent(flow -> flow.addIssueIf(CdkPredicate.isFalse(), SQS_MANAGED_DISABLED_MESSAGE, new IssueLocation[0]));
    }
}

