/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonarsource.analyzer.commons.ShannonEntropy;

@Rule(key="S6418")
public class HardCodedCredentialsEntropyCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_SECRET_KEYWORDS = "api[_.-]?key,auth,credential,secret,token";
    private static final String DEFAULT_RANDOMNESS_SENSIBILITY = "3.0";
    private static final Pattern POSTVALIDATION_PATTERN = Pattern.compile("[a-zA-Z0-9_.+/~$-]([a-zA-Z0-9_.+/=~$-]|\\\\\\\\(?![ntr\"])){14,1022}[a-zA-Z0-9_.+/=~$-]");
    private static final String MESSAGE = "\"%s\" detected here, make sure this is not a hard-coded secret.";
    private Collection<Pattern> patterns = null;
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="api[_.-]?key,auth,credential,secret,token")
    public String secretKeyWords = "api[_.-]?key,auth,credential,secret,token";
    @RuleProperty(key="randomnessSensibility", description="Allows to tune the Randomness Sensibility (from 0 to 10)", defaultValue="3.0")
    public double randomnessSensibility = Double.parseDouble("3.0");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, this::checkAnnotatedAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_LIST, this::checkParameterList);
        context.registerSyntaxNodeConsumer(Tree.Kind.REGULAR_ARGUMENT, this::checkRegularArgument);
        context.registerSyntaxNodeConsumer(Tree.Kind.DICTIONARY_LITERAL, this::checkDictionaryLiteral);
    }

    private void patternMatch(Name name, Tree location, String value, SubscriptionContext subscriptionContext) {
        this.patternMatch(name.name(), location, value, subscriptionContext);
    }

    private void patternMatch(String name, Tree location, String value, SubscriptionContext subscriptionContext) {
        if (!HardCodedCredentialsEntropyCheck.valuePassesPostValidation(value) || !this.entropyShouldRaise(value)) {
            return;
        }
        this.patterns().stream().filter(pattern -> pattern.matcher(name).matches()).findFirst().ifPresent(pattern -> subscriptionContext.addIssue(location, String.format(MESSAGE, name)));
    }

    private void checkParameterList(SubscriptionContext subscriptionContext) {
        ParameterList parameterList = (ParameterList)subscriptionContext.syntaxNode();
        parameterList.nonTuple().stream().filter(parameter -> parameter.name() != null).filter(parameter -> parameter.defaultValue() != null).filter(parameter -> parameter.defaultValue().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})).forEach(parameter -> {
            String value = ((StringLiteral)parameter.defaultValue()).trimmedQuotesValue();
            this.patternMatch(parameter.name(), (Tree)parameter.defaultValue(), value, subscriptionContext);
        });
    }

    private void checkDictionaryLiteral(SubscriptionContext subscriptionContext) {
        DictionaryLiteral dictionaryLiteral = (DictionaryLiteral)subscriptionContext.syntaxNode();
        dictionaryLiteral.elements().stream().filter(e -> e.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR})).map(KeyValuePair.class::cast).filter(keyValuePair -> keyValuePair.value().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})).filter(keyValuePair -> keyValuePair.key().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})).forEach(keyValuePair -> {
            String value = ((StringLiteral)keyValuePair.value()).trimmedQuotesValue();
            String key = ((StringLiteral)keyValuePair.key()).trimmedQuotesValue();
            this.patternMatch(key, (Tree)keyValuePair.value(), value, subscriptionContext);
        });
    }

    private void checkRegularArgument(SubscriptionContext subscriptionContext) {
        Expression expression;
        RegularArgument regularArgument = (RegularArgument)subscriptionContext.syntaxNode();
        Name keywordArgument = regularArgument.keywordArgument();
        if (keywordArgument != null && (expression = regularArgument.expression()) instanceof StringLiteral) {
            StringLiteral expression2 = (StringLiteral)expression;
            String value = expression2.trimmedQuotesValue();
            this.patternMatch(keywordArgument, (Tree)regularArgument, value, subscriptionContext);
        }
    }

    private void checkAnnotatedAssignment(SubscriptionContext subscriptionContext) {
        AnnotatedAssignment annotatedAssignment = (AnnotatedAssignment)subscriptionContext.syntaxNode();
        Expression assignedValue = annotatedAssignment.assignedValue();
        Expression assignedVariable = annotatedAssignment.variable();
        if (assignedValue instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)assignedValue;
            if (assignedVariable instanceof Name) {
                Name name = (Name)assignedVariable;
                this.patternMatch(name, (Tree)assignedValue, stringLiteral.trimmedQuotesValue(), subscriptionContext);
            }
        }
    }

    private void checkAssignment(SubscriptionContext subscriptionContext) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        AssignmentStatement assignment = (AssignmentStatement)subscriptionContext.syntaxNode();
        Expression assignedValue = assignment.assignedValue();
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            expressions.addAll(Expressions.getExpressionsFromRhs(assignedValue));
        } else {
            expressions.add(assignedValue);
        }
        expressions.stream().filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).forEach(expression -> Expressions.getAssignedName((Expression)expression).ifPresent(name -> {
            String value = expression.trimmedQuotesValue();
            this.patternMatch((Name)name, (Tree)expression, value, subscriptionContext);
        }));
    }

    private static boolean valuePassesPostValidation(String value) {
        return POSTVALIDATION_PATTERN.matcher(value).matches();
    }

    private boolean entropyShouldRaise(String value) {
        return ShannonEntropy.calculate((String)value) > this.randomnessSensibility;
    }

    private Collection<Pattern> patterns() {
        if (this.patterns == null) {
            this.patterns = Stream.of(this.secretKeyWords.split(",")).map(word -> Pattern.compile("(" + word + ")", 2)).toList();
        }
        return this.patterns;
    }
}

