/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.ParameterV2;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.matchers.TypeMatcher;
import org.sonar.plugins.python.api.types.v2.matchers.TypeMatchers;

@Rule(key="S930")
public class ArgumentNumberCheck
extends PythonSubscriptionCheck {
    private static final String FUNCTION_DEFINITION = "Function definition.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            PythonType patt0$temp = callExpression.callee().typeV2();
            if (patt0$temp instanceof FunctionType) {
                FunctionType functionType = (FunctionType)patt0$temp;
                ArgumentNumberCheck.checkFunctionType(ctx, callExpression, functionType);
            }
        });
    }

    private static void checkFunctionType(SubscriptionContext ctx, CallExpression callExpression, FunctionType functionType) {
        if (ArgumentNumberCheck.isException(ctx, callExpression, functionType)) {
            return;
        }
        ArgumentNumberCheck.checkPositionalParameters(ctx, callExpression, functionType);
        ArgumentNumberCheck.checkKeywordArguments(ctx, callExpression, functionType, callExpression.callee());
    }

    private static void checkPositionalParameters(SubscriptionContext ctx, CallExpression callExpression, FunctionType functionType) {
        int self = 0;
        if (ArgumentNumberCheck.isCalledAsInstanceMethod(callExpression, functionType) && ArgumentNumberCheck.functionHasSelfParameter(functionType)) {
            self = 1;
        }
        Map<String, ParameterV2> positionalParamsWithoutDefault = ArgumentNumberCheck.positionalParamsWithoutDefault(functionType);
        long nbPositionalParamsWithDefault = functionType.parameters().stream().filter(parameterName -> !parameterName.isKeywordOnly() && parameterName.hasDefaultValue()).count();
        List<RegularArgument> arguments = callExpression.arguments().stream().map(RegularArgument.class::cast).toList();
        long nbPositionalArgs = arguments.stream().filter(a -> a.keywordArgument() == null).count();
        long nbNonKeywordOnlyPassedWithKeyword = arguments.stream().map(RegularArgument::keywordArgument).filter(k -> k != null && positionalParamsWithoutDefault.containsKey(k.name()) && !((ParameterV2)positionalParamsWithoutDefault.get(k.name())).isPositionalOnly()).count();
        int minimumPositionalArgs = positionalParamsWithoutDefault.size();
        String expected = "" + (minimumPositionalArgs - self);
        long nbMissingArgs = (long)minimumPositionalArgs - nbPositionalArgs - (long)self - nbNonKeywordOnlyPassedWithKeyword;
        if (nbMissingArgs > 0L) {
            String message = "Add " + nbMissingArgs + " missing arguments; ";
            if (nbPositionalParamsWithDefault > 0L) {
                expected = "at least " + expected;
            }
            ArgumentNumberCheck.addPositionalIssue(ctx, (Tree)callExpression.callee(), functionType, message, expected);
        } else if (nbMissingArgs + nbPositionalParamsWithDefault + nbNonKeywordOnlyPassedWithKeyword < 0L) {
            String message = "Remove " + (-nbMissingArgs - nbPositionalParamsWithDefault) + " unexpected arguments; ";
            if (nbPositionalParamsWithDefault > 0L) {
                expected = "at most " + ((long)(minimumPositionalArgs - self) + nbPositionalParamsWithDefault);
            }
            ArgumentNumberCheck.addPositionalIssue(ctx, (Tree)callExpression.callee(), functionType, message, expected);
        }
    }

    private static boolean isCalledAsInstanceMethod(CallExpression callExpression, FunctionType functionType) {
        QualifiedExpression qualifiedExpression;
        Expression expression;
        return functionType.isInstanceMethod() && (expression = callExpression.callee()) instanceof QualifiedExpression && (qualifiedExpression = (QualifiedExpression)expression).qualifier().typeV2() instanceof ObjectType;
    }

    private static boolean functionHasSelfParameter(FunctionType functionType) {
        return !functionType.parameters().isEmpty();
    }

    private static Map<String, ParameterV2> positionalParamsWithoutDefault(FunctionType functionType) {
        int unnamedIndex = 0;
        HashMap<String, ParameterV2> result = new HashMap<String, ParameterV2>();
        for (ParameterV2 parameter : functionType.parameters()) {
            if (parameter.isKeywordOnly() || parameter.hasDefaultValue()) continue;
            String name = parameter.name();
            if (name == null || name.isEmpty()) {
                result.put("!unnamed" + unnamedIndex, parameter);
                ++unnamedIndex;
                continue;
            }
            result.put(parameter.name(), parameter);
        }
        return result;
    }

    private static void addPositionalIssue(SubscriptionContext ctx, Tree tree, FunctionType functionType, String message, String expected) {
        String msg = message + "'" + functionType.name() + "' expects " + expected + " positional arguments.";
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(tree, msg);
        ArgumentNumberCheck.addSecondary(functionType, preciseIssue);
    }

    private static boolean isException(SubscriptionContext ctx, CallExpression callExpression, FunctionType functionType) {
        return functionType.hasDecorators() || functionType.hasVariadicParameter() || callExpression.arguments().stream().anyMatch(argument -> argument.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR})) || ArgumentNumberCheck.extendsZopeInterface(ctx, callExpression) || ArgumentNumberCheck.isCalledAsBoundInstanceMethod(callExpression) || ArgumentNumberCheck.isSuperCall(ctx, callExpression) || ArgumentNumberCheck.isReceiverTypeVar(ctx, callExpression) || ArgumentNumberCheck.isReceiverTypeInstance(ctx, callExpression);
    }

    private static boolean extendsZopeInterface(SubscriptionContext ctx, CallExpression callExpression) {
        TypeMatcher matcher = TypeMatchers.isFunctionOwnerSatisfying((TypeMatcher)TypeMatchers.isOrExtendsType((String)"zope.interface.Interface"));
        return matcher.isTrueFor(callExpression.callee(), ctx);
    }

    private static boolean isCalledAsBoundInstanceMethod(CallExpression callExpression) {
        PythonType pythonType = callExpression.callee().typeV2();
        if (pythonType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)pythonType;
            return functionType.isInstanceMethod() && !callExpression.callee().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR});
        }
        return false;
    }

    private static boolean isReceiverTypeVar(SubscriptionContext ctx, CallExpression callExpression) {
        Expression expression = callExpression.callee();
        if (expression instanceof QualifiedExpression) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            return TypeMatchers.isObjectSatisfying((TypeMatcher)TypeMatchers.isOrExtendsType((String)"typing.TypeVar")).isTrueFor(qualifiedExpression.qualifier(), ctx);
        }
        return false;
    }

    private static boolean isReceiverTypeInstance(SubscriptionContext ctx, CallExpression callExpression) {
        Expression expression = callExpression.callee();
        if (expression instanceof QualifiedExpression) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            return TypeMatchers.isObjectSatisfying((TypeMatcher)TypeMatchers.isOrExtendsType((String)"type")).isTrueFor(qualifiedExpression.qualifier(), ctx);
        }
        return false;
    }

    private static boolean isSuperCall(SubscriptionContext ctx, CallExpression callExpression) {
        Expression expression = callExpression.callee();
        if (expression instanceof QualifiedExpression) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            return TypeMatchers.isObjectOfType((String)"super").isTrueFor(qualifiedExpression.qualifier(), ctx);
        }
        return false;
    }

    private static void addSecondary(FunctionType functionType, PythonCheck.PreciseIssue preciseIssue) {
        functionType.definitionLocation().ifPresent(location -> preciseIssue.secondary(location, FUNCTION_DEFINITION));
    }

    private static void checkKeywordArguments(SubscriptionContext ctx, CallExpression callExpression, FunctionType functionType, Expression callee) {
        List parameters = functionType.parameters();
        Set mandatoryParamNamesKeywordOnly = parameters.stream().filter(parameterName -> parameterName.isKeywordOnly() && !parameterName.hasDefaultValue()).map(ParameterV2::name).collect(Collectors.toSet());
        for (Object argument : callExpression.arguments()) {
            RegularArgument arg = (RegularArgument)argument;
            Name keyword = arg.keywordArgument();
            if (keyword == null) continue;
            if (parameters.stream().noneMatch(parameter -> keyword.name().equals(parameter.name()) && !parameter.isPositionalOnly())) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)argument, "Remove this unexpected named argument '" + keyword.name() + "'.");
                ArgumentNumberCheck.addSecondary(functionType, preciseIssue);
                continue;
            }
            mandatoryParamNamesKeywordOnly.remove(keyword.name());
        }
        if (!mandatoryParamNamesKeywordOnly.isEmpty()) {
            StringBuilder message = new StringBuilder("Add the missing keyword arguments: ");
            for (String param : mandatoryParamNamesKeywordOnly) {
                message.append("'").append(param).append("' ");
            }
            PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)callee, message.toString().trim());
            ArgumentNumberCheck.addSecondary(functionType, preciseIssue);
        }
    }
}

