/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7502")
public class AsyncioTaskNotStoredCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Save this task in a variable to prevent premature garbage collection.";
    private static final Set<String> TASK_CREATION_FUNCTIONS = Set.of("asyncio.create_task", "asyncio.ensure_future");
    private final List<TypeCheckBuilder> asyncioTaskTypeChecks = new ArrayList<TypeCheckBuilder>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void setupTypeChecker(SubscriptionContext ctx) {
        this.asyncioTaskTypeChecks.clear();
        TASK_CREATION_FUNCTIONS.forEach(fqn -> this.asyncioTaskTypeChecks.add(ctx.typeChecker().typeCheckBuilder().isTypeWithName(fqn)));
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Expression callee = callExpression.callee();
        PythonType calleeType = callee.typeV2();
        if (this.asyncioTaskTypeChecks.stream().noneMatch(t -> t.check(calleeType) == TriBool.TRUE)) {
            return;
        }
        if (TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ASSIGNMENT_EXPRESSION, Tree.Kind.ANNOTATED_ASSIGNMENT, Tree.Kind.CALL_EXPR, Tree.Kind.RETURN_STMT}) == null) {
            ctx.addIssue((Tree)callee, MESSAGE);
        }
    }
}

