/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4144")
public class DuplicatedMethodImplementationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to %s on line %s.";
    private static final String QUICK_FIX_MESSAGE = "Call %s inside this function.";
    private static final Set<String> ALLOWED_FIRST_ARG_NAMES = Set.of("self", "cls", "mcs", "metacls");
    private static final Set<String> CLASS_AND_STATIC_DECORATORS = Set.of("classmethod", "staticmethod");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            MethodVisitor methodVisitor = new MethodVisitor();
            classDef.body().accept((TreeVisitor)methodVisitor);
            for (int i = 1; i < methodVisitor.methods.size(); ++i) {
                DuplicatedMethodImplementationCheck.checkMethods(methodVisitor.methods.get(i), methodVisitor.methods, i, ctx);
            }
        });
    }

    private static void checkMethods(FunctionDef suspiciousMethod, List<FunctionDef> methods, int index, SubscriptionContext ctx) {
        StatementList suspiciousBody = suspiciousMethod.body();
        if (DuplicatedMethodImplementationCheck.isException(suspiciousMethod)) {
            return;
        }
        for (int j = 0; j < index; ++j) {
            FunctionDef originalMethod = methods.get(j);
            StatementList originalBody = originalMethod.body();
            if (!CheckUtils.areEquivalent((Tree)originalBody, (Tree)suspiciousBody)) continue;
            int line = originalMethod.name().firstToken().line();
            String message = String.format(MESSAGE, originalMethod.name().name(), line);
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)suspiciousMethod.name(), message).secondary((Tree)originalMethod.name(), "Original");
            DuplicatedMethodImplementationCheck.addQuickFix(issue, originalMethod, suspiciousMethod);
            break;
        }
    }

    private static boolean isException(FunctionDef suspiciousMethod) {
        int nbActualStatements;
        boolean hasDocString = suspiciousMethod.docstring() != null;
        StatementList suspiciousBody = suspiciousMethod.body();
        List statements = suspiciousBody.statements();
        int n = nbActualStatements = hasDocString ? statements.size() - 1 : statements.size();
        if (nbActualStatements == 0 || DuplicatedMethodImplementationCheck.isOnASingleLine(suspiciousBody, hasDocString)) {
            return true;
        }
        return nbActualStatements == 1 && ((Statement)statements.get(statements.size() - 1)).is(new Tree.Kind[]{Tree.Kind.RAISE_STMT});
    }

    private static boolean isOnASingleLine(StatementList statementList, boolean hasDocString) {
        int first = hasDocString ? 1 : 0;
        return ((Statement)statementList.statements().get(first)).firstToken().line() == ((Statement)statementList.statements().get(statementList.statements().size() - 1)).lastToken().line();
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, FunctionDef originalMethod, FunctionDef suspiciousMethod) {
        ParameterList parameters = originalMethod.parameters();
        if (parameters != null) {
            List all = parameters.all();
            if (all.size() == 1 && !ALLOWED_FIRST_ARG_NAMES.contains(((AnyParameter)all.get(0)).firstToken().value())) {
                return;
            }
            if (all.size() > 1) {
                return;
            }
        }
        boolean containsReturnStatement = originalMethod.body().statements().stream().anyMatch(s -> s.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT}));
        Object replacementText = "";
        if (containsReturnStatement) {
            replacementText = "return ";
        }
        if (DuplicatedMethodImplementationCheck.isClassOrStaticMethod(originalMethod)) {
            ClassDef methodClass = (ClassDef)TreeUtils.firstAncestorOfKind((Tree)originalMethod, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF});
            if (methodClass != null) {
                replacementText = (String)replacementText + methodClass.name().name() + ".";
            }
        } else {
            replacementText = (String)replacementText + "self.";
        }
        replacementText = (String)replacementText + originalMethod.name().name() + "()";
        PythonTextEdit edit = TextEditUtils.replace((Tree)suspiciousMethod.body(), (String)replacementText);
        PythonQuickFix fix = PythonQuickFix.newQuickFix((String)String.format(QUICK_FIX_MESSAGE, originalMethod.name().name())).addTextEdit(new PythonTextEdit[]{edit}).build();
        issue.addQuickFix(fix);
    }

    private static boolean isClassOrStaticMethod(FunctionDef originalMethod) {
        return originalMethod.decorators().stream().anyMatch(d -> {
            NameImpl nameImpl;
            Expression patt0$temp = d.expression();
            return patt0$temp instanceof NameImpl && CLASS_AND_STATIC_DECORATORS.contains((nameImpl = (NameImpl)patt0$temp).name());
        });
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        List<FunctionDef> methods = new ArrayList<FunctionDef>();

        private MethodVisitor() {
        }

        public void visitClassDef(ClassDef classDef) {
        }

        public void visitFunctionDef(FunctionDef functionDef) {
            if (functionDef.isMethodDefinition()) {
                this.methods.add(functionDef);
            }
            super.visitFunctionDef(functionDef);
        }
    }
}

