/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1515")
public class FunctionUsingLoopVariableCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, FunctionUsingLoopVariableCheck::checkFunctionLike);
        context.registerSyntaxNodeConsumer(Tree.Kind.LAMBDA, FunctionUsingLoopVariableCheck::checkFunctionLike);
    }

    private static void checkFunctionLike(SubscriptionContext ctx) {
        FunctionLike functionLike = (FunctionLike)ctx.syntaxNode();
        Tree enclosingLoop = FunctionUsingLoopVariableCheck.enclosingLoop(functionLike);
        if (enclosingLoop == null || !enclosingLoop.is(new Tree.Kind[]{Tree.Kind.WHILE_STMT, Tree.Kind.FOR_STMT, Tree.Kind.GENERATOR_EXPR, Tree.Kind.LIST_COMPREHENSION, Tree.Kind.SET_COMPREHENSION, Tree.Kind.DICT_COMPREHENSION})) {
            return;
        }
        if (FunctionUsingLoopVariableCheck.isReturnedOrCalledWithinLoop(functionLike, enclosingLoop)) {
            return;
        }
        Set<Symbol> enclosingScopeSymbols = FunctionUsingLoopVariableCheck.getEnclosingScopeSymbols(enclosingLoop);
        for (Symbol symbol : enclosingScopeSymbols) {
            ArrayList<Tree> problematicUsages = new ArrayList<Tree>();
            ArrayList<Tree> bindingUsages = new ArrayList<Tree>();
            for (Usage usage : symbol.usages()) {
                Tree usageTree = usage.tree();
                if (FunctionUsingLoopVariableCheck.isUsedInFunctionLike(usageTree, functionLike) && !usage.isBindingUsage()) {
                    if (TreeUtils.firstAncestor((Tree)usageTree, t -> t.is(new Tree.Kind[]{Tree.Kind.NONLOCAL_STMT, Tree.Kind.GLOBAL_STMT})) != null) {
                        problematicUsages.clear();
                        break;
                    }
                    problematicUsages.add(usageTree);
                }
                if (!usage.isBindingUsage() || !FunctionUsingLoopVariableCheck.isWithinEnclosingLoop(usageTree, enclosingLoop)) continue;
                bindingUsages.add(usageTree);
            }
            FunctionUsingLoopVariableCheck.reportIssue(ctx, functionLike, problematicUsages, bindingUsages, symbol.name());
        }
    }

    private static void reportIssue(SubscriptionContext ctx, FunctionLike functionLike, List<Tree> problematicUsages, List<Tree> bindingUsages, String symbolName) {
        if (!problematicUsages.isEmpty() && !bindingUsages.isEmpty()) {
            PythonCheck.PreciseIssue issue = functionLike.is(new Tree.Kind[]{Tree.Kind.FUNCDEF}) ? ctx.addIssue(problematicUsages.get(0), String.format("Add a parameter to function \"%s\" and use variable \"%s\" as its default value;The value of \"%s\" might change at the next loop iteration.", ((FunctionDef)functionLike).name().name(), symbolName, symbolName)).secondary((Tree)((FunctionDef)functionLike).name(), "Function capturing the variable") : ctx.addIssue(problematicUsages.get(0), String.format("Add a parameter to the parent lambda function and use variable \"%s\" as its default value; The value of \"%s\" might change at the next loop iteration.", symbolName, symbolName)).secondary(((LambdaExpression)functionLike).lambdaKeyword(), "Lambda capturing the variable");
            for (Tree bindingUsage : bindingUsages) {
                issue.secondary(bindingUsage, "Assignment in the loop");
            }
        }
    }

    private static boolean isUsedInFunctionLike(Tree usageTree, FunctionLike functionLike) {
        ParameterList parameters = functionLike.parameters();
        if (parameters != null && FunctionUsingLoopVariableCheck.isUsedAsDefaultValue(usageTree, parameters)) {
            return false;
        }
        if (functionLike.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            FunctionDef functionDef = (FunctionDef)functionLike;
            for (Decorator decorator : functionDef.decorators()) {
                if (!TreeUtils.hasDescendant((Tree)decorator, t -> t.equals((Object)usageTree))) continue;
                return false;
            }
        }
        return TreeUtils.hasDescendant((Tree)functionLike, tree -> tree.equals((Object)usageTree));
    }

    private static boolean isUsedAsDefaultValue(Tree usageTree, ParameterList parameters) {
        return parameters.nonTuple().stream().anyMatch(p -> p.defaultValue() != null && (usageTree.equals((Object)p.defaultValue()) || TreeUtils.hasDescendant((Tree)p.defaultValue(), t -> t.equals((Object)usageTree))));
    }

    private static boolean isWithinEnclosingLoop(Tree usageTree, Tree enclosingLoop) {
        return TreeUtils.hasDescendant((Tree)enclosingLoop, tree -> tree.equals((Object)usageTree));
    }

    private static Set<Symbol> getEnclosingScopeSymbols(Tree enclosingLoop) {
        if (enclosingLoop.is(new Tree.Kind[]{Tree.Kind.LIST_COMPREHENSION}) || enclosingLoop.is(new Tree.Kind[]{Tree.Kind.SET_COMPREHENSION}) || enclosingLoop.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
            return ((ComprehensionExpression)enclosingLoop).localVariables();
        }
        if (enclosingLoop.is(new Tree.Kind[]{Tree.Kind.DICT_COMPREHENSION})) {
            return ((DictCompExpression)enclosingLoop).localVariables();
        }
        Tree enclosingScope = TreeUtils.firstAncestor((Tree)enclosingLoop, tree -> tree.is(new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF, Tree.Kind.FILE_INPUT}));
        if (enclosingScope == null) {
            return Collections.emptySet();
        }
        if (enclosingScope.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            return ((FunctionLike)enclosingScope).localVariables();
        }
        if (enclosingScope.is(new Tree.Kind[]{Tree.Kind.CLASSDEF})) {
            return ((ClassDef)enclosingScope).classFields();
        }
        return ((FileInput)enclosingScope).globalVariables();
    }

    private static Tree enclosingLoop(FunctionLike functionLike) {
        return TreeUtils.firstAncestor((Tree)functionLike, t -> t.is(new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF, Tree.Kind.WHILE_STMT, Tree.Kind.FOR_STMT, Tree.Kind.RETURN_STMT, Tree.Kind.YIELD_STMT, Tree.Kind.GENERATOR_EXPR, Tree.Kind.COMP_FOR, Tree.Kind.LIST_COMPREHENSION, Tree.Kind.SET_COMPREHENSION, Tree.Kind.DICT_COMPREHENSION}));
    }

    private static boolean isReturnedOrCalledWithinLoop(FunctionLike functionLike, Tree enclosingLoop) {
        Tree parentCallExpr = TreeUtils.firstAncestor((Tree)functionLike, t -> !t.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED}));
        if (parentCallExpr != null && parentCallExpr.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return true;
        }
        CallOrReturnVisitor callOrReturnVisitor = new CallOrReturnVisitor(functionLike, enclosingLoop);
        enclosingLoop.accept((TreeVisitor)callOrReturnVisitor);
        return callOrReturnVisitor.isReturned || callOrReturnVisitor.isCalled;
    }

    static class CallOrReturnVisitor
    extends BaseTreeVisitor {
        Tree enclosingLoop;
        FunctionLike functionLike;
        boolean isReturned = false;
        boolean isCalled = false;

        public CallOrReturnVisitor(FunctionLike functionLike, Tree enclosingLoop) {
            this.functionLike = functionLike;
            this.enclosingLoop = enclosingLoop;
        }

        public void visitCallExpression(CallExpression callExpression) {
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol != null) {
                if (this.functionLike.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
                    this.isCalled |= calleeSymbol.equals((Object)((FunctionDef)this.functionLike).name().symbol());
                } else {
                    Name name = CallOrReturnVisitor.variableAssigned((LambdaExpression)this.functionLike);
                    if (name != null) {
                        this.isCalled |= calleeSymbol.equals((Object)name.symbol());
                    }
                }
            }
            super.visitCallExpression(callExpression);
        }

        public void visitReturnStatement(ReturnStatement returnStatement) {
            this.isReturned |= this.isFunctionLikeReturned((Tree)returnStatement);
        }

        public void visitYieldStatement(YieldStatement yieldStatement) {
            this.isReturned |= this.isFunctionLikeReturned((Tree)yieldStatement);
        }

        private static Name variableAssigned(LambdaExpression lambdaExpression) {
            Name name;
            Expression expression;
            AssignmentStatement assignmentStatement;
            Tree parentAssignment = TreeUtils.firstAncestorOfKind((Tree)lambdaExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
            if (parentAssignment != null && ((Expression)((ExpressionList)(assignmentStatement = (AssignmentStatement)parentAssignment).lhsExpressions().get(0)).expressions().get(0)).is(new Tree.Kind[]{Tree.Kind.NAME}) && (expression = Expressions.singleAssignedValue(name = (Name)((ExpressionList)assignmentStatement.lhsExpressions().get(0)).expressions().get(0))) != null && expression.equals((Object)lambdaExpression)) {
                return name;
            }
            return null;
        }

        private boolean isFunctionLikeReturned(Tree yieldOrReturnTree) {
            if (this.functionLike.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
                Symbol functionSymbol = ((FunctionDef)this.functionLike).name().symbol();
                return TreeUtils.hasDescendant((Tree)yieldOrReturnTree, d -> TreeUtils.getSymbolFromTree((Tree)d).filter(symbol -> symbol.equals((Object)functionSymbol)).isPresent());
            }
            return CallOrReturnVisitor.isLambdaReturned((LambdaExpression)this.functionLike, yieldOrReturnTree);
        }

        private static boolean isLambdaReturned(LambdaExpression lambdaExpression, Tree yieldOrReturnTree) {
            Tree parentAssignment = TreeUtils.firstAncestorOfKind((Tree)lambdaExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
            if (parentAssignment != null) {
                AssignmentStatement assignmentStatement = (AssignmentStatement)parentAssignment;
                return SymbolUtils.assignmentsLhs((AssignmentStatement)assignmentStatement).stream().map(TreeUtils::getSymbolFromTree).anyMatch(symbol -> TreeUtils.hasDescendant((Tree)yieldOrReturnTree, d -> TreeUtils.getSymbolFromTree((Tree)d).equals(symbol)));
            }
            return false;
        }
    }
}

