/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ItemOperationsType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5644")
public class ItemOperationsTypeCheck
extends ItemOperationsType {
    @Override
    public boolean isValidSubscription(Expression subscriptionObject, String requiredMethod, @Nullable String classRequiredMethod, Map<LocationInFile, String> secondaries) {
        InferredType type;
        String typeName;
        if (subscriptionObject.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
            return false;
        }
        if (ItemOperationsTypeCheck.isInvalidSubscriptionCallExpr(subscriptionObject, secondaries)) {
            return false;
        }
        Optional symbolOptional = TreeUtils.getSymbolFromTree((Tree)subscriptionObject);
        if (symbolOptional.isPresent()) {
            Symbol symbol = (Symbol)symbolOptional.get();
            if (ItemOperationsTypeCheck.isTypingOrCollectionsSymbol(symbol)) {
                return true;
            }
            if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION, Symbol.Kind.CLASS})) {
                return ItemOperationsTypeCheck.isValidSubscriptionSymbol(symbol, subscriptionObject, secondaries, requiredMethod, classRequiredMethod);
            }
        }
        String secondaryMessage = (typeName = InferredTypes.typeName((InferredType)(type = subscriptionObject.type()))) != null ? String.format("Definition of \"%s\".", typeName) : "Type definition.";
        secondaries.put(InferredTypes.typeClassLocation((InferredType)type), secondaryMessage);
        return type.canHaveMember(requiredMethod);
    }

    private static boolean isValidSubscriptionSymbol(Symbol symbol, Expression subscriptionObject, Map<LocationInFile, String> secondaries, String requiredMethod, @Nullable String classRequiredMethod) {
        LocationInFile locationInFile = symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) ? ((FunctionSymbol)symbol).definitionLocation() : ((ClassSymbol)symbol).definitionLocation();
        secondaries.put(locationInFile, "Definition of \"%s\".".formatted(symbol.name()));
        return ItemOperationsTypeCheck.isSubscriptionInClassArg(subscriptionObject) || ItemOperationsTypeCheck.canHaveMethod(symbol, requiredMethod, classRequiredMethod) || ItemOperationsTypeCheck.isValidGenericUsage(symbol, subscriptionObject, requiredMethod);
    }

    private static boolean isValidGenericUsage(Symbol symbol, Expression subscriptionObject, String requiredMethod) {
        return "__getitem__".equals(requiredMethod) && symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS}) && !ItemOperationsTypeCheck.areSomeSubscriptsSuspicious(subscriptionObject);
    }

    private static boolean areSomeSubscriptsSuspicious(Expression subscriptionObject) {
        SubscriptionExpression subscriptionExpr;
        Tree subscriptionExprTree = TreeUtils.firstAncestorOfKind((Tree)subscriptionObject, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.SUBSCRIPTION});
        return subscriptionExprTree instanceof SubscriptionExpression && (subscriptionExpr = (SubscriptionExpression)subscriptionExprTree).subscripts().expressions().stream().allMatch(ItemOperationsTypeCheck::isSubscriptSuspicious);
    }

    private static boolean isSubscriptSuspicious(Expression expr) {
        return !expr.is(new Tree.Kind[]{Tree.Kind.NAME, Tree.Kind.STRING_LITERAL});
    }

    private static boolean isInvalidSubscriptionCallExpr(Expression expression, Map<LocationInFile, String> secondaries) {
        FunctionSymbol functionSymbol;
        CallExpression callExpression;
        Symbol symbol;
        if (expression instanceof CallExpression && (symbol = (callExpression = (CallExpression)expression).calleeSymbol()) instanceof FunctionSymbol && (functionSymbol = (FunctionSymbol)symbol).isAsynchronous()) {
            secondaries.put(functionSymbol.definitionLocation(), "Definition of \"%s\".".formatted(functionSymbol.name()));
            return true;
        }
        return false;
    }

    private static boolean isSubscriptionInClassArg(Expression subscriptionObject) {
        Optional<ClassDef> classDefOptional = Optional.ofNullable(TreeUtils.firstAncestorOfKind((Tree)subscriptionObject, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF})).map(ClassDef.class::cast);
        List classArguments = classDefOptional.map(ClassDef::args).map(ArgList::arguments).orElse(List.of());
        Stream<Expression> onlyRegularArgumentExpressions = classArguments.stream().flatMap(TreeUtils.toStreamInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression);
        Stream<Expression> subscriptionObjectStream = onlyRegularArgumentExpressions.flatMap(TreeUtils.toStreamInstanceOfMapper(SubscriptionExpression.class)).map(SubscriptionExpression::object);
        return subscriptionObjectStream.anyMatch(arg_0 -> ((Expression)subscriptionObject).equals(arg_0));
    }

    @Override
    public String message(@Nullable String name, String missingMethod) {
        if (name != null) {
            return String.format("Fix this code; \"%s\" does not have a \"%s\" method.", name, missingMethod);
        }
        return String.format("Fix this code; this expression does not have a \"%s\" method.", missingMethod);
    }

    private static boolean isTypingOrCollectionsSymbol(Symbol symbol) {
        String fullyQualifiedName = symbol.fullyQualifiedName();
        return fullyQualifiedName != null && (fullyQualifiedName.startsWith("typing") || fullyQualifiedName.startsWith("collections"));
    }

    private static boolean canHaveMethod(Symbol symbol, String requiredMethod, @Nullable String classRequiredMethod) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ((FunctionSymbol)symbol).hasDecorators();
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.canHaveMember(requiredMethod) || classRequiredMethod != null && classSymbol.canHaveMember(classRequiredMethod) || classSymbol.hasDecorators();
    }
}

