/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.api.PythonPunctuator;

public abstract class IterationOnNonIterable
extends PythonSubscriptionCheck {
    static final String SECONDARY_MESSAGE = "Definition of \"%s\".";
    static final String DEFAULT_SECONDARY_MESSAGE = "Type definition.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.UNPACKING_EXPR, this::checkUnpackingExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::checkForStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, this::checkForComprehension);
        context.registerSyntaxNodeConsumer(Tree.Kind.YIELD_STMT, this::checkYieldStatement);
    }

    private void checkAssignment(SubscriptionContext ctx) {
        AssignmentStatement assignmentStatement = (AssignmentStatement)ctx.syntaxNode();
        ExpressionList expressionList = (ExpressionList)assignmentStatement.lhsExpressions().get(0);
        HashMap<LocationInFile, String> secondaries = new HashMap<LocationInFile, String>();
        if (IterationOnNonIterable.isLhsIterable(expressionList) && !this.isValidIterable(assignmentStatement.assignedValue(), secondaries)) {
            IterationOnNonIterable.reportIssue(ctx, assignmentStatement.assignedValue(), secondaries, this.message(assignmentStatement.assignedValue(), false));
        }
    }

    private static boolean isLhsIterable(ExpressionList expressionList) {
        if (expressionList.expressions().size() > 1) {
            return true;
        }
        Expression expression = (Expression)expressionList.expressions().get(0);
        return expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}) || expression.is(new Tree.Kind[]{Tree.Kind.TUPLE});
    }

    private void checkForComprehension(SubscriptionContext ctx) {
        HashMap<LocationInFile, String> secondaries;
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        Expression expression = comprehensionFor.iterable();
        if (!this.isValidIterable(expression, secondaries = new HashMap<LocationInFile, String>())) {
            IterationOnNonIterable.reportIssue(ctx, expression, secondaries, this.message(expression, false));
        }
    }

    private static void reportIssue(SubscriptionContext ctx, Expression expression, Map<LocationInFile, String> secondaries, String message) {
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)expression, message);
        secondaries.keySet().stream().filter(Objects::nonNull).forEach(location -> preciseIssue.secondary(location, (String)secondaries.get(location)));
    }

    private void checkYieldStatement(SubscriptionContext ctx) {
        HashMap<LocationInFile, String> secondaries;
        YieldStatement yieldStatement = (YieldStatement)ctx.syntaxNode();
        YieldExpression yieldExpression = yieldStatement.yieldExpression();
        if (yieldExpression.fromKeyword() == null) {
            return;
        }
        Expression expression = (Expression)yieldExpression.expressions().get(0);
        if (!this.isValidIterable(expression, secondaries = new HashMap<LocationInFile, String>())) {
            IterationOnNonIterable.reportIssue(ctx, expression, secondaries, this.message(expression, false));
        }
    }

    private void checkUnpackingExpression(SubscriptionContext ctx) {
        HashMap<LocationInFile, String> secondaries;
        UnpackingExpression unpackingExpression = (UnpackingExpression)ctx.syntaxNode();
        if (unpackingExpression.starToken().type().equals((Object)PythonPunctuator.MUL_MUL)) {
            return;
        }
        Expression expression = unpackingExpression.expression();
        if (!this.isValidIterable(expression, secondaries = new HashMap<LocationInFile, String>())) {
            IterationOnNonIterable.reportIssue(ctx, expression, secondaries, this.message(expression, false));
        }
    }

    private void checkForStatement(SubscriptionContext ctx) {
        boolean isAsync;
        ForStatement forStatement = (ForStatement)ctx.syntaxNode();
        List testExpressions = forStatement.testExpressions();
        boolean bl = isAsync = forStatement.asyncKeyword() != null;
        if (testExpressions.size() > 1) {
            return;
        }
        Expression expression = (Expression)testExpressions.get(0);
        HashMap<LocationInFile, String> secondaries = new HashMap<LocationInFile, String>();
        if (!isAsync && !this.isValidIterable(expression, secondaries)) {
            IterationOnNonIterable.reportIssue(ctx, expression, secondaries, this.message(expression, true));
        }
    }

    abstract boolean isAsyncIterable(Expression var1);

    abstract boolean isValidIterable(Expression var1, Map<LocationInFile, String> var2);

    abstract String message(Expression var1, boolean var2);
}

