/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S117")
public class LocalVariableAndParameterNameConventionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression %s.";
    private static final String PARAMETER = "parameter";
    private static final String LOCAL_VAR = "local variable";
    private static final EnumSet<UsageV2.Kind> USAGES = EnumSet.of(UsageV2.Kind.PARAMETER, UsageV2.Kind.LOOP_DECLARATION, UsageV2.Kind.ASSIGNMENT_LHS);
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][a-z0-9_]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[_a-z][a-z0-9_]*$")
    public String format = "^[_a-z][a-z0-9_]*$";
    private Pattern constantPattern;
    private Pattern pattern;
    private static final Set<String> ML_VARIABLE_NAMES = Set.of("X_train", "X_test", "Y_train", "Y_test", "X", "Y");
    private TypeCheckBuilder isDjangoModelTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        this.pattern = Pattern.compile(this.format);
        this.constantPattern = Pattern.compile(CONSTANT_PATTERN);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, this::checkFunctionDef);
    }

    private void initializeTypeChecker(SubscriptionContext ctx) {
        this.isDjangoModelTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("type");
    }

    private void checkFunctionDef(SubscriptionContext ctx) {
        FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
        TreeUtils.getLocalVariableSymbols((FunctionDef)funcDef).stream().sorted(Comparator.comparing(SymbolV2::name)).forEach(s -> this.checkName((SymbolV2)s, ctx));
    }

    private void checkName(SymbolV2 symbol, SubscriptionContext ctx) {
        String name = symbol.name();
        if (ML_VARIABLE_NAMES.contains(name)) {
            return;
        }
        if (!this.pattern.matcher(name).matches()) {
            if (this.isType(symbol)) {
                return;
            }
            symbol.usages().stream().filter(usage -> USAGES.contains(usage.kind())).sorted(Comparator.comparingInt(u -> u.tree().firstToken().line())).limit(1L).forEach(usage -> this.raiseIssueForNameAndUsage(ctx, name, (UsageV2)usage));
        }
    }

    private boolean isType(SymbolV2 symbolV2) {
        Symbol symbolV1 = SymbolUtils.symbolV2ToSymbolV1((SymbolV2)symbolV2).orElse(null);
        return symbolV1 != null && (LocalVariableAndParameterNameConventionCheck.isExtendingType(symbolV1) || LocalVariableAndParameterNameConventionCheck.isAssignedFromTyping(symbolV2) || this.isPythonTypeAClassType(symbolV2));
    }

    private static boolean isExtendingType(Symbol symbol) {
        boolean isInferredTypeExtendingType = symbol.usages().stream().map(Usage::tree).filter(Expression.class::isInstance).map(Expression.class::cast).anyMatch(e -> e.type().mustBeOrExtend("type"));
        boolean isAnnotatedTypeStartingWithTyping = symbol.annotatedTypeName() != null && symbol.annotatedTypeName().startsWith("typing.");
        return isInferredTypeExtendingType || isAnnotatedTypeStartingWithTyping;
    }

    private static boolean isAssignedFromTyping(SymbolV2 symbol) {
        List assignedValues = symbol.usages().stream().filter(u -> u.kind() == UsageV2.Kind.ASSIGNMENT_LHS).flatMap(usage -> LocalVariableAndParameterNameConventionCheck.getAssignedValue(usage.tree())).toList();
        for (Expression assignedValue : assignedValues) {
            Symbol assignedSymbol = LocalVariableAndParameterNameConventionCheck.getTypingSymbol(assignedValue);
            if (assignedSymbol == null || !LocalVariableAndParameterNameConventionCheck.isExtendingType(assignedSymbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isPythonTypeAClassType(SymbolV2 symbol) {
        PythonType type = SymbolUtils.getPythonType((SymbolV2)symbol);
        return this.isDjangoModelTypeCheck.check(type).isTrue();
    }

    private static Stream<Expression> getAssignedValue(Tree assignmentName) {
        AssignmentStatement assignmentStmt = (AssignmentStatement)TreeUtils.firstAncestorOfClass((Tree)assignmentName, AssignmentStatement.class);
        if (assignmentStmt != null) {
            return Stream.of(assignmentStmt.assignedValue());
        }
        return Stream.empty();
    }

    @Nullable
    private static Symbol getTypingSymbol(Expression expr) {
        SubscriptionExpression subscriptionExpression;
        Expression expression;
        if (expr instanceof SubscriptionExpression && (expression = (subscriptionExpression = (SubscriptionExpression)expr).object()) instanceof Name) {
            Name name = (Name)expression;
            return name.symbol();
        }
        return null;
    }

    private void raiseIssueForNameAndUsage(SubscriptionContext ctx, String name, UsageV2 usage) {
        String type = PARAMETER;
        UsageV2.Kind kind = usage.kind();
        if (kind == UsageV2.Kind.ASSIGNMENT_LHS) {
            type = LOCAL_VAR;
            if (this.constantPattern.matcher(name).matches()) {
                return;
            }
        } else if (kind == UsageV2.Kind.LOOP_DECLARATION) {
            type = LOCAL_VAR;
            if (name.length() <= 1) {
                return;
            }
        } else if (kind == UsageV2.Kind.PARAMETER && LocalVariableAndParameterNameConventionCheck.isParameterNameFromOverriddenMethod(usage, name)) {
            return;
        }
        ctx.addIssue(usage.tree(), String.format(MESSAGE, type, name, this.format));
    }

    private static boolean isParameterNameFromOverriddenMethod(UsageV2 usage, String parameterName) {
        Tree functionLikeAncestor = TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA});
        if (functionLikeAncestor == null || functionLikeAncestor.is(new Tree.Kind[]{Tree.Kind.LAMBDA})) {
            return false;
        }
        FunctionDef functionDef = (FunctionDef)functionLikeAncestor;
        int parameterIndex = LocalVariableAndParameterNameConventionCheck.getParameterIndex(functionDef, parameterName);
        if (parameterIndex < 0) {
            return false;
        }
        FunctionSymbol functionSymbol = TreeUtils.getFunctionSymbolFromDef((FunctionDef)functionDef);
        if (functionSymbol == null) {
            return false;
        }
        List overriddenMethods = SymbolUtils.getOverriddenMethods((FunctionSymbol)functionSymbol);
        for (FunctionSymbol overriddenMethod : overriddenMethods) {
            String overriddenParamName;
            List overriddenParams = overriddenMethod.parameters();
            if (parameterIndex >= overriddenParams.size() || !parameterName.equals(overriddenParamName = ((FunctionSymbol.Parameter)overriddenParams.get(parameterIndex)).name())) continue;
            return true;
        }
        return false;
    }

    private static int getParameterIndex(FunctionDef functionDef, String parameterName) {
        List parameters = TreeUtils.positionalParameters((FunctionDef)functionDef);
        for (int i = 0; i < parameters.size(); ++i) {
            Name paramName = ((Parameter)parameters.get(i)).name();
            if (paramName == null || !parameterName.equals(paramName.name())) continue;
            return i;
        }
        return -1;
    }
}

