/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.v2.matchers.TypeMatcher;
import org.sonar.plugins.python.api.types.v2.matchers.TypeMatchers;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7504")
public class UnnecessaryListCastCheck
extends PythonSubscriptionCheck {
    private static final TypeMatcher isListCallMatcher = TypeMatchers.isType((String)"list");
    private static final TypeMatcher modifyingListMethodMatcher = TypeMatchers.any((TypeMatcher[])new TypeMatcher[]{TypeMatchers.withFQN((String)"list.append"), TypeMatchers.withFQN((String)"list.extend"), TypeMatchers.withFQN((String)"list.insert"), TypeMatchers.withFQN((String)"list.remove"), TypeMatchers.withFQN((String)"list.pop"), TypeMatchers.withFQN((String)"typing.MutableSequence.clear"), TypeMatchers.withFQN((String)"list.sort"), TypeMatchers.withFQN((String)"typing.MutableSequence.reverse")});
    private static final TypeMatcher modifyingDictMethodMatcher = TypeMatchers.any((TypeMatcher[])new TypeMatcher[]{TypeMatchers.withFQN((String)"dict.pop"), TypeMatchers.withFQN((String)"typing.MutableMapping.popitem"), TypeMatchers.withFQN((String)"typing.MutableMapping.clear"), TypeMatchers.withFQN((String)"typing.MutableMapping.update"), TypeMatchers.withFQN((String)"typing.MutableMapping.setdefault")});
    private static TypeMatcher dictViewMethodMatcher = TypeMatchers.any((TypeMatcher[])new TypeMatcher[]{TypeMatchers.withFQN((String)"dict.keys"), TypeMatchers.withFQN((String)"dict.items")});

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, UnnecessaryListCastCheck::checkForStatements);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, UnnecessaryListCastCheck::checkComprehensions);
    }

    private static void checkForStatements(SubscriptionContext ctx) {
        ForStatement stmt = (ForStatement)ctx.syntaxNode();
        UnnecessaryListCastCheck.hasListCallOnIterable(ctx, stmt.testExpressions()).filter(listCall -> !UnnecessaryListCastCheck.isListModifiedInLoop(ctx, listCall, stmt)).ifPresent(listCall -> UnnecessaryListCastCheck.raiseIssue(ctx, listCall));
    }

    private static void checkComprehensions(SubscriptionContext ctx) {
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        UnnecessaryListCastCheck.hasListCallOnIterable(ctx, List.of(comprehensionFor.iterable())).ifPresent(listCall -> UnnecessaryListCastCheck.raiseIssue(ctx, listCall));
    }

    private static Optional<CallExpression> hasListCallOnIterable(SubscriptionContext ctx, List<Expression> testExpressions) {
        CallExpression callExpression;
        Expression expression;
        if (testExpressions.size() == 1 && (expression = testExpressions.get(0)) instanceof CallExpression && UnnecessaryListCastCheck.isListCall(ctx, callExpression = (CallExpression)expression) && UnnecessaryListCastCheck.getFirstAndOnlyRegularArgument(callExpression).isPresent()) {
            return Optional.of(callExpression);
        }
        return Optional.empty();
    }

    private static boolean isListCall(SubscriptionContext ctx, CallExpression callExpression) {
        return isListCallMatcher.isTrueFor(callExpression.callee(), ctx);
    }

    private static boolean isListModifiedInLoop(SubscriptionContext ctx, CallExpression callExpression, ForStatement forStatement) {
        Optional<Name> listName = UnnecessaryListCastCheck.getFirstNameArgument(callExpression);
        if (listName.isPresent()) {
            ModifyingCollectionTreeVisitor visitor = new ModifyingCollectionTreeVisitor(ctx, listName.get(), modifyingListMethodMatcher, false);
            forStatement.accept((TreeVisitor)visitor);
            return visitor.isModifyingCollection();
        }
        Optional<Name> dictNameAndMethod = UnnecessaryListCastCheck.getDictNameFromViewCall(ctx, callExpression);
        if (dictNameAndMethod.isPresent()) {
            ModifyingCollectionTreeVisitor visitor = new ModifyingCollectionTreeVisitor(ctx, dictNameAndMethod.get(), modifyingDictMethodMatcher, true);
            forStatement.accept((TreeVisitor)visitor);
            return visitor.isModifyingCollection();
        }
        return false;
    }

    public static Optional<Name> getFirstNameArgument(CallExpression callExpression) {
        return UnnecessaryListCastCheck.getFirstAndOnlyRegularArgument(callExpression).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class));
    }

    private static Optional<Name> getDictNameFromViewCall(SubscriptionContext ctx, CallExpression callExpression) {
        return UnnecessaryListCastCheck.getFirstAndOnlyRegularArgument(callExpression).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).filter(innerCall -> UnnecessaryListCastCheck.isDictViewCall(ctx, innerCall)).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::qualifier).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class));
    }

    private static boolean isDictViewCall(SubscriptionContext ctx, CallExpression callExpr) {
        return dictViewMethodMatcher.isTrueFor(callExpr.callee(), ctx);
    }

    private static Optional<RegularArgument> getFirstAndOnlyRegularArgument(CallExpression callExpression) {
        Object e;
        if (callExpression.arguments().size() == 1 && (e = callExpression.arguments().get(0)) instanceof RegularArgument) {
            RegularArgument regularArgument = (RegularArgument)e;
            return Optional.of(regularArgument);
        }
        return Optional.empty();
    }

    private static void raiseIssue(SubscriptionContext ctx, CallExpression listCall) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)listCall.callee(), "Remove this unnecessary `list()` call on an already iterable object.");
        Optional.ofNullable(listCall.argumentList()).map(argList -> TreeUtils.treeToString((Tree)argList, (boolean)false)).map(replacementText -> TextEditUtils.replace((Tree)listCall, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)"Remove the \"list\" call", (PythonTextEdit[])new PythonTextEdit[]{textEdit})).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
    }

    private static class ModifyingCollectionTreeVisitor
    extends BaseTreeVisitor {
        private final SubscriptionContext ctx;
        private final Name collectionName;
        private final TypeMatcher methodsMatcher;
        private final boolean isDict;
        private boolean isModifyingCollection = false;

        ModifyingCollectionTreeVisitor(SubscriptionContext ctx, Name collectionName, TypeMatcher methodsMatcher, boolean isDict) {
            this.ctx = ctx;
            this.collectionName = collectionName;
            this.methodsMatcher = methodsMatcher;
            this.isDict = isDict;
        }

        public boolean isModifyingCollection() {
            return this.isModifyingCollection;
        }

        public void visitCallExpression(CallExpression callExpr) {
            super.visitCallExpression(callExpr);
            SymbolV2 symbol = this.collectionName.symbolV2();
            if (symbol != null) {
                this.isModifyingCollection |= ModifyingCollectionTreeVisitor.isMethodReceiverInstanceOf(callExpr, symbol) && this.isModifyingMethod(callExpr);
            }
        }

        public void visitDelStatement(DelStatement delStatement) {
            SymbolV2 symbol;
            super.visitDelStatement(delStatement);
            if (this.isDict && (symbol = this.collectionName.symbolV2()) != null) {
                this.isModifyingCollection |= delStatement.expressions().stream().anyMatch(expr -> ModifyingCollectionTreeVisitor.isSubscriptionOf(expr, symbol));
            }
        }

        public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
            SymbolV2 symbol;
            super.visitAssignmentStatement(assignmentStatement);
            if (this.isDict && (symbol = this.collectionName.symbolV2()) != null) {
                this.isModifyingCollection |= assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).anyMatch(expr -> ModifyingCollectionTreeVisitor.isSubscriptionOf(expr, symbol));
            }
        }

        private static boolean isMethodReceiverInstanceOf(CallExpression callExpr, SymbolV2 collectionSymbol) {
            QualifiedExpression qualifiedExpression;
            Expression expression = callExpr.callee();
            if (expression instanceof QualifiedExpression && (expression = (qualifiedExpression = (QualifiedExpression)expression).qualifier()) instanceof Name) {
                Name name = (Name)expression;
                SymbolV2 symbolV2 = name.symbolV2();
                return symbolV2 != null && symbolV2.equals(collectionSymbol);
            }
            return false;
        }

        private static boolean isSubscriptionOf(Expression expr, SymbolV2 collectionSymbol) {
            SubscriptionExpression subscriptionExpr;
            Expression expression;
            if (expr instanceof SubscriptionExpression && (expression = (subscriptionExpr = (SubscriptionExpression)expr).object()) instanceof Name) {
                Name name = (Name)expression;
                SymbolV2 symbolV2 = name.symbolV2();
                return symbolV2 != null && symbolV2.equals(collectionSymbol);
            }
            return false;
        }

        private boolean isModifyingMethod(CallExpression callExpression) {
            return this.methodsMatcher.isTrueFor(callExpression.callee(), this.ctx);
        }
    }
}

