/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7511")
public class UnnecessarySubscriptReversalCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isReversedTypeCheck;
    private TypeCheckBuilder isSortedTypeCheck;
    private TypeCheckBuilder isSetTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isReversedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("reversed");
        this.isSortedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("sorted");
        this.isSetTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("set");
    }

    private void check(SubscriptionContext ctx) {
        TreeUtils.toOptionalInstanceOf(CallExpression.class, (Tree)ctx.syntaxNode()).filter(this::isSensitiveCall).flatMap(callExpression -> UnnecessarySubscriptReversalCheck.getArgumentSubscriptReversal(callExpression).or(() -> UnnecessarySubscriptReversalCheck.getOuterSubscriptReversal(callExpression))).ifPresent(redundantSubscriptReversal -> ctx.addIssue(redundantSubscriptReversal, "Remove this redundant subscript reversal"));
    }

    private static Optional<Tree> getOuterSubscriptReversal(CallExpression callExpression) {
        return Optional.of(callExpression).map(Tree::parent).filter(UnnecessarySubscriptReversalCheck::isSubscriptReversal);
    }

    private static Optional<Tree> getArgumentSubscriptReversal(CallExpression callExpression) {
        return TreeUtils.nthArgumentOrKeywordOptional((int)0, (String)"", (List)callExpression.arguments()).map(RegularArgument::expression).filter(arg -> UnnecessarySubscriptReversalCheck.isSubscriptReversal((Tree)arg) || UnnecessarySubscriptReversalCheck.isAssignedToSubscriptReversal(arg)).map(Tree.class::cast);
    }

    private static boolean isAssignedToSubscriptReversal(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && UnnecessarySubscriptReversalCheck.getUsageCount(name = (Name)argumentExpression) == 2 && UnnecessarySubscriptReversalCheck.isSubscriptReversal((Tree)Expressions.singleAssignedValue(name));
    }

    private boolean isSensitiveCall(CallExpression callExpression) {
        return Stream.of(this.isReversedTypeCheck, this.isSortedTypeCheck, this.isSetTypeCheck).map(check -> check.check(callExpression.callee().typeV2())).anyMatch(arg_0 -> TriBool.TRUE.equals(arg_0));
    }

    private static boolean isSubscriptReversal(@Nullable Tree expression) {
        NumericLiteral numericLiteral;
        Expression expression2;
        UnaryExpression unaryExpression;
        Expression expression3;
        SliceItem sliceItem;
        Object e;
        SliceExpression sliceExpression;
        return expression instanceof SliceExpression && (sliceExpression = (SliceExpression)expression).sliceList().slices().size() == 1 && (e = sliceExpression.sliceList().slices().get(0)) instanceof SliceItem && (sliceItem = (SliceItem)e).lowerBound() == null && sliceItem.upperBound() == null && (expression3 = sliceItem.stride()) instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression3).is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) && (expression2 = unaryExpression.expression()) instanceof NumericLiteral && (numericLiteral = (NumericLiteral)expression2).valueAsLong() == 1L;
    }

    private static int getUsageCount(Name name) {
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return 0;
        }
        return symbol.usages().size();
    }
}

