/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.checks.utils.ImportedNamesCollector;
import org.sonar.python.checks.utils.StringLiteralValuesCollector;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT = "(_[a-zA-Z0-9_]*|dummy|unused|ignored)";
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";
    private static final String SEQUENCE_UNPACKING_MESSAGE = "Replace the unused local variable \"%s\" with \"_\".";
    private static final String LOOP_INDEX_MESSAGE = "Replace the unused loop index \"%s\" with \"_\".";
    private static final String RENAME_QUICK_FIX_MESSAGE = "Replace with \"_\"";
    private static final String EXCEPT_CLAUSE_QUICK_FIX_MESSAGE = "Remove the unused local variable";
    private static final String ASSIGNMENT_QUICK_FIX_MESSAGE = "Remove assignment target";
    private static final String SECONDARY_MESSAGE = "Assignment to unused local variable \"%s\".";
    @RuleProperty(key="regex", description="Regular expression used to identify variable name to ignore.", defaultValue="(_[a-zA-Z0-9_]*|dummy|unused|ignored)")
    public String format = "(_[a-zA-Z0-9_]*|dummy|unused|ignored)";
    private Pattern pattern;
    private boolean isTemplateVariablesAccessEnabled = false;

    public void initialize(SubscriptionCheck.Context context) {
        this.pattern = Pattern.compile(this.format);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::checkTemplateVariablesAccessEnabled);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((FunctionDef)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((DictCompExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.LIST_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.GENERATOR_EXPR, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
    }

    private void checkTemplateVariablesAccessEnabled(SubscriptionContext ctx) {
        ImportedNamesCollector importedNamesCollector = new ImportedNamesCollector();
        importedNamesCollector.collect(ctx.syntaxNode());
        this.isTemplateVariablesAccessEnabled = importedNamesCollector.anyMatches("pandas"::equals);
    }

    private void checkLocalVars(SubscriptionContext ctx, Tree functionTree, Set<Symbol> symbols) {
        StringLiteralValuesCollector stringLiteralValuesCollector = new StringLiteralValuesCollector();
        if (this.isTemplateVariablesAccessEnabled) {
            stringLiteralValuesCollector.collect(functionTree);
        }
        if (CheckUtils.containsCallToLocalsFunction(functionTree)) {
            return;
        }
        symbols.stream().filter(s -> !this.pattern.matcher(s.name()).matches()).filter(UnusedLocalVariableCheck::hasOnlyBindingUsages).filter(UnusedLocalVariableCheck::isNotUpdatingParameterDict).filter(symbol -> !UnusedLocalVariableCheck.isVariableAccessedInStringTemplate(symbol, stringLiteralValuesCollector)).forEach(symbol -> {
            List<Usage> usages = symbol.usages().stream().filter(usage -> usage.tree().parent() == null || !usage.tree().parent().is(new Tree.Kind[]{Tree.Kind.PARAMETER})).filter(usage -> !UnusedLocalVariableCheck.isTupleDeclaration(usage)).filter(usage -> usage.kind() != Usage.Kind.FUNC_DECLARATION).filter(usage -> usage.kind() != Usage.Kind.CLASS_DECLARATION).toList();
            if (!usages.isEmpty()) {
                Usage firstUsage = usages.get(0);
                PythonCheck.PreciseIssue issue = this.createIssue(ctx, (Symbol)symbol, firstUsage);
                usages.stream().skip(1L).forEach(usage -> issue.secondary(usage.tree(), String.format(SECONDARY_MESSAGE, symbol.name())));
            }
        });
    }

    private static boolean isVariableAccessedInStringTemplate(Symbol symbol, StringLiteralValuesCollector stringLiteralsCollector) {
        return stringLiteralsCollector.anyMatches(s -> s.matches(".*@" + symbol.name() + "((\\s+.*)|$)"));
    }

    public PythonCheck.PreciseIssue createIssue(SubscriptionContext ctx, Symbol symbol, Usage usage) {
        if (UnusedLocalVariableCheck.isSequenceUnpacking(usage)) {
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)RENAME_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.replace((Tree)usage.tree(), (String)"_")});
            PythonCheck.PreciseIssue issue = ctx.addIssue(usage.tree(), String.format(SEQUENCE_UNPACKING_MESSAGE, symbol.name()));
            issue.addQuickFix(quickFix);
            return issue;
        }
        if (UnusedLocalVariableCheck.isLoopIndex(usage, symbol)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(usage.tree(), String.format(LOOP_INDEX_MESSAGE, symbol.name()));
            if (UnusedLocalVariableCheck.isUnderscoreSymbolAlreadyAssigned(ctx, usage)) {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)RENAME_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.replace((Tree)usage.tree(), (String)"_")});
                issue.addQuickFix(quickFix);
            }
            return issue;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue(usage.tree(), String.format(MESSAGE, symbol.name()));
        UnusedLocalVariableCheck.createExceptClauseQuickFix(usage, issue);
        UnusedLocalVariableCheck.createAssignmentQuickFix(usage, issue);
        return issue;
    }

    private static void createAssignmentQuickFix(Usage usage, PythonCheck.PreciseIssue issue) {
        if (usage.kind().equals((Object)Usage.Kind.ASSIGNMENT_LHS)) {
            Statement assignmentStatement = (Statement)TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT});
            Optional.ofNullable(assignmentStatement).filter(stmt -> stmt.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})).map(AssignmentStatement.class::cast).ifPresent(stmt -> {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)ASSIGNMENT_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)usage.tree(), (Tree)stmt.assignedValue().firstToken())});
                issue.addQuickFix(quickFix);
            });
            Optional.ofNullable(assignmentStatement).filter(stmt -> stmt.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT})).map(AnnotatedAssignment.class::cast).map(AnnotatedAssignment::assignedValue).ifPresent(assignedValue -> {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)ASSIGNMENT_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)usage.tree(), (Tree)assignedValue.firstToken())});
                issue.addQuickFix(quickFix);
            });
            Tree assignmentTree = TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_EXPRESSION});
            Optional.ofNullable(assignmentTree).map(AssignmentExpression.class::cast).ifPresent(assignmentExpr -> {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)ASSIGNMENT_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{UnusedLocalVariableCheck.createAssignmentExpressionQuickFix(usage, assignmentExpr)});
                issue.addQuickFix(quickFix);
            });
        }
    }

    private static PythonTextEdit createAssignmentExpressionQuickFix(Usage usage, AssignmentExpression assignmentExpression) {
        Expression expression = assignmentExpression.expression();
        Tree parent = assignmentExpression.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED}) && expression instanceof Name) {
            Name nameExpr = (Name)expression;
            return TextEditUtils.replace((Tree)parent, (String)nameExpr.name());
        }
        return TextEditUtils.removeUntil((Tree)usage.tree(), (Tree)expression.firstToken());
    }

    private static boolean isUnderscoreSymbolAlreadyAssigned(SubscriptionContext ctx, Usage usage) {
        Tree searchTree;
        Symbol foundUnderscoreSymbol = null;
        Tree tree = searchTree = usage.kind().equals((Object)Usage.Kind.LOOP_DECLARATION) ? ctx.syntaxNode() : null;
        while (foundUnderscoreSymbol == null && searchTree != null) {
            if (searchTree.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
                foundUnderscoreSymbol = ((FunctionDef)searchTree).localVariables().stream().filter(symbol1 -> "_".equals(symbol1.name())).findAny().orElse(null);
            } else if (searchTree.is(new Tree.Kind[]{Tree.Kind.FILE_INPUT})) {
                foundUnderscoreSymbol = ((FileInputImpl)searchTree).globalVariables().stream().filter(symbol1 -> "_".equals(symbol1.name())).findAny().orElse(null);
            }
            searchTree = TreeUtils.firstAncestor((Tree)searchTree, a -> a.is(new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.FILE_INPUT}));
        }
        return foundUnderscoreSymbol == null;
    }

    private static boolean isLoopIndex(Usage usage, Symbol symbol) {
        EnumSet<Usage.Kind> allowedKinds = EnumSet.of(Usage.Kind.LOOP_DECLARATION, Usage.Kind.COMP_DECLARATION);
        Optional<Symbol> optionalSymbol = Optional.of(usage).filter(u -> allowedKinds.contains(u.kind())).map(Usage::tree).map(a -> ((Name)a).symbol());
        return optionalSymbol.map(value -> value.equals((Object)symbol)).orElse(false);
    }

    private static void createExceptClauseQuickFix(Usage usage, PythonCheck.PreciseIssue issue) {
        Optional.of(usage).filter(u -> u.kind() == Usage.Kind.EXCEPTION_INSTANCE).map(Usage::tree).map(Tree::parent).filter(ExceptClause.class::isInstance).map(ExceptClause.class::cast).filter(ec -> Objects.nonNull(ec.exception())).map(ec -> {
            String replacement = TreeUtils.treeToString((Tree)ec.exception(), (boolean)false) + ":";
            Expression from = ec.exception();
            Token to = ec.colon();
            PythonTextEdit textEdit = TextEditUtils.replaceRange((Tree)from, (Tree)to, (String)replacement);
            return PythonQuickFix.newQuickFix((String)EXCEPT_CLAUSE_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{textEdit});
        }).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
    }

    private static boolean hasOnlyBindingUsages(Symbol symbol) {
        List usages = symbol.usages();
        if (UnusedLocalVariableCheck.isOnlyTypeAnnotation(usages)) {
            return false;
        }
        return usages.stream().noneMatch(usage -> usage.kind() == Usage.Kind.IMPORT) && usages.stream().allMatch(Usage::isBindingUsage);
    }

    private static boolean isNotUpdatingParameterDict(Symbol symbol) {
        List usages = symbol.usages();
        return usages.stream().noneMatch(UnusedLocalVariableCheck::isDictAssignmentExpressionUsage) || usages.stream().noneMatch(usage -> usage.kind() == Usage.Kind.PARAMETER);
    }

    private static boolean isDictAssignmentExpressionUsage(Usage usage) {
        CompoundAssignmentStatement compoundAssignmentStatement;
        Tree compoundAssignmentTree = TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.COMPOUND_ASSIGNMENT});
        return compoundAssignmentTree instanceof CompoundAssignmentStatement && "|=".equals((compoundAssignmentStatement = (CompoundAssignmentStatement)compoundAssignmentTree).compoundAssignmentToken().value()) && compoundAssignmentStatement.lhsExpression().type().mustBeOrExtend("dict");
    }

    private static boolean isOnlyTypeAnnotation(List<Usage> usages) {
        return usages.size() == 1 && usages.get(0).isBindingUsage() && TreeUtils.firstAncestor((Tree)usages.get(0).tree(), t -> t.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT}) && ((AnnotatedAssignment)t).assignedValue() == null) != null;
    }

    private static boolean isTupleDeclaration(Usage usage) {
        Tree tree = usage.tree();
        Predicate<Tree> isTupleDeclaration = t -> {
            if (t.is(new Tree.Kind[]{Tree.Kind.TUPLE})) return true;
            if (t.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_LIST})) {
                if (((ExpressionList)t).expressions().size() > 1) return true;
            }
            if (!t.is(new Tree.Kind[]{Tree.Kind.FOR_STMT})) return false;
            if (((ForStatement)t).expressions().size() <= 1) return false;
            if (!(tree instanceof Expression)) return false;
            Expression treeExpr = (Expression)tree;
            if (!((ForStatement)t).expressions().contains(treeExpr)) return false;
            return true;
        };
        return !UnusedLocalVariableCheck.isSequenceUnpacking(usage) && TreeUtils.firstAncestor((Tree)tree, isTupleDeclaration) != null;
    }

    private static boolean isSequenceUnpacking(Usage usage) {
        return Optional.of(usage).filter(u -> u.kind() == Usage.Kind.ASSIGNMENT_LHS).map(Usage::tree).map(tree -> TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.EXPRESSION_LIST})).map(ExpressionList.class::cast).filter(list -> list.expressions().size() > 1).isPresent();
    }
}

