/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.tree.TreeUtils;

public abstract class NonCallableCalled
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Expression callee = callExpression.callee();
            PythonType calleeType = callee.typeV2();
            if (!this.isException((SubscriptionContext)ctx, calleeType) && this.isCallMemberMissing((SubscriptionContext)ctx, calleeType)) {
                String name = TreeUtils.nameFromExpression((Expression)callee);
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)callee, this.message(calleeType, name));
                calleeType.definitionLocation().ifPresent(location -> preciseIssue.secondary(location, "Definition."));
            }
        });
    }

    protected boolean isCallMemberMissing(SubscriptionContext ctx, PythonType calleeType) {
        return ctx.typeChecker().typeCheckBuilder().hasMember("__call__").check(calleeType) == TriBool.FALSE;
    }

    protected boolean isException(SubscriptionContext ctx, PythonType calleeType) {
        return !this.isExpectedTypeSource(ctx, calleeType);
    }

    protected abstract boolean isExpectedTypeSource(SubscriptionContext var1, PythonType var2);

    protected static String addTypeName(PythonType type) {
        return type.displayName().map(d -> " has type " + d + " and it").orElse("");
    }

    protected String message(PythonType calleeType, @Nullable String name) {
        if (name != null) {
            return String.format("Fix this call; Previous type checks suggest that \"%s\"%s is not callable.", name, NonCallableCalled.addTypeName(calleeType));
        }
        return String.format("Fix this call; Previous type checks suggest that this expression%s is not callable.", NonCallableCalled.addTypeName(calleeType));
    }
}

