/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7483")
public class AsyncFunctionWithTimeoutCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this \"timeout\" parameter and use a timeout context manager instead.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, AsyncFunctionWithTimeoutCheck::checkFunctionDef);
    }

    private static void checkFunctionDef(SubscriptionContext ctx) {
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        Token asyncKeyword = functionDef.asyncKeyword();
        if (asyncKeyword == null) {
            return;
        }
        FunctionType functionType = (FunctionType)functionDef.name().typeV2();
        if (AsyncFunctionWithTimeoutCheck.mightBeOverridingMethod(functionType)) {
            return;
        }
        for (Parameter parameter : TreeUtils.nonTupleParameters((FunctionDef)functionDef)) {
            Name parameterName = parameter.name();
            if (parameterName == null || !"timeout".equals(parameterName.name())) continue;
            ctx.addIssue((Tree)parameter, MESSAGE).secondary(asyncKeyword, "This function is async.");
            return;
        }
    }

    private static boolean mightBeOverridingMethod(FunctionType functionType) {
        ClassType classType;
        PythonType pythonType = functionType.owner();
        return pythonType instanceof ClassType && ((classType = (ClassType)pythonType).hasUnresolvedHierarchy() || classType.inheritedMember(functionType.name()).isPresent());
    }
}

