/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AwaitExpression;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7490")
public class CancellationScopeNoCheckpointCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a checkpoint inside this cancellation scope.";
    private static final String SECONDARY_MESSAGE = "This checkpoint is not awaited.";
    private static final String TRIO_CHECKPOINT = "trio.lowlevel.checkpoint";
    private static final Map<String, String> TYPE_WITH_FQN_MAP = Map.of("trio.CancelScope", "trio.lowlevel.checkpoint", "trio.move_on_after", "trio.lowlevel.checkpoint", "trio.move_on_at", "trio.lowlevel.checkpoint");
    private static final String ANYIO_CHECKPOINT = "anyio.lowlevel.checkpoint";
    private static final Map<String, String> TYPE_WITH_NAME_MAP = Map.of("asyncio.timeout", "asyncio.sleep", "anyio.CancelScope", "anyio.lowlevel.checkpoint", "anyio.move_on_after", "anyio.lowlevel.checkpoint", "anyio.move_on_at", "anyio.lowlevel.checkpoint");
    private TypeCheckMap<TypeCheckBuilder> typeCheckMap;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckers);
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, this::checkCancellationScope);
    }

    private void initializeTypeCheckers(SubscriptionContext ctx) {
        this.typeCheckMap = new TypeCheckMap();
        TYPE_WITH_FQN_MAP.forEach((typeName, checkpointFunction) -> this.typeCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(typeName), (Object)ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(checkpointFunction)));
        TYPE_WITH_NAME_MAP.forEach((typeName, checkpointFunction) -> this.typeCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeWithName(typeName), (Object)ctx.typeChecker().typeCheckBuilder().isTypeWithName(checkpointFunction)));
    }

    private void checkCancellationScope(SubscriptionContext ctx) {
        WithStatement withStatement = (WithStatement)ctx.syntaxNode();
        for (WithItem withItem : withStatement.withItems()) {
            Expression test = withItem.test();
            TypeCheckBuilder checkpointTypeChecker = this.getCheckpointTypeCheckerForScope(test);
            if (checkpointTypeChecker == null) continue;
            CheckpointVisitor visitor = new CheckpointVisitor(checkpointTypeChecker);
            withStatement.statements().accept((TreeVisitor)visitor);
            if (visitor.hasCheckpoint()) continue;
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)test, MESSAGE);
            visitor.checkpointedTrees.forEach(t -> issue.secondary(t, SECONDARY_MESSAGE));
        }
    }

    @Nullable
    private TypeCheckBuilder getCheckpointTypeCheckerForScope(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            CallExpression callExpression = (CallExpression)expression;
            Expression callee = callExpression.callee();
            return this.typeCheckMap.getOptionalForType(callee.typeV2()).orElse(null);
        }
        return this.typeCheckMap.getOptionalForType(expression.typeV2()).orElse(null);
    }

    private static class CheckpointVisitor
    extends BaseTreeVisitor {
        private final TypeCheckBuilder checkpointTypeChecker;
        private boolean checkpointFound = false;
        private List<Tree> checkpointedTrees = new ArrayList<Tree>();

        CheckpointVisitor(TypeCheckBuilder checkpointTypeChecker) {
            this.checkpointTypeChecker = checkpointTypeChecker;
        }

        boolean hasCheckpoint() {
            return this.checkpointFound;
        }

        public void visitAwaitExpression(AwaitExpression awaitExpression) {
            this.checkpointFound = true;
        }

        public void visitYieldExpression(YieldExpression yieldExpression) {
            this.checkpointFound = true;
        }

        public void visitForStatement(ForStatement forStatement) {
            if (forStatement.isAsync()) {
                this.checkpointFound = true;
            }
            if (!this.checkpointFound) {
                super.visitForStatement(forStatement);
            }
        }

        public void visitCallExpression(CallExpression callExpression) {
            Expression callee = callExpression.callee();
            if (this.checkpointTypeChecker.check(callee.typeV2()) == TriBool.TRUE) {
                this.checkpointedTrees.add((Tree)callExpression);
            }
            super.visitCallExpression(callExpression);
        }

        protected void scan(@Nullable Tree tree) {
            if (!this.checkpointFound && tree != null) {
                tree.accept((TreeVisitor)this);
            }
        }
    }
}

