/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7519")
public class ConstantValueDictComprehensionCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Replace with dict fromkeys method call";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, ConstantValueDictComprehensionCheck::checkDictComprehension);
    }

    private static void checkDictComprehension(SubscriptionContext ctx) {
        DictCompExpression dictComprehension = (DictCompExpression)ctx.syntaxNode();
        if (ConstantValueDictComprehensionCheck.isConstantValueDictComprehension(dictComprehension)) {
            ctx.addIssue((Tree)dictComprehension, MESSAGE);
        }
    }

    private static boolean isConstantValueDictComprehension(DictCompExpression dictComprehension) {
        if (!(dictComprehension.keyExpression() instanceof Name) || dictComprehension.comprehensionFor().nestedClause() != null) {
            return false;
        }
        Expression expression = dictComprehension.valueExpression();
        if (expression instanceof Name) {
            Name valueName = (Name)expression;
            SymbolV2 valueSymbol = valueName.symbolV2();
            return valueSymbol == null || !valueSymbol.usages().stream().map(UsageV2::tree).allMatch(ut -> TreeUtils.firstAncestor((Tree)ut, dictComprehension::equals) != null);
        }
        return dictComprehension.valueExpression().is(new Tree.Kind[]{Tree.Kind.NONE, Tree.Kind.STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.BOOLEAN_LITERAL_PATTERN});
    }
}

