/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S5712")
public class NotImplementedErrorInOperatorMethodsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Return \"NotImplemented\" instead of raising \"NotImplementedError\"";
    private static final String NOT_IMPLEMENTED_ERROR = "NotImplementedError";
    private static final List<String> OPERATOR_METHODS = Arrays.asList("__lt__", "__le__", "__eq__", "__ne__", "__gt__", "__ge__", "__add__", "__sub__", "__mul__", "__matmul__", "__truediv__", "__floordiv__", "__mod__", "__divmod__", "__pow__", "__lshift__", "__rshift__", "__and__", "__xor__", "__or__", "__radd__", "__rsub__", "__rmul__", "__rmatmul__", "__rtruediv__", "__rfloordiv__", "__rmod__", "__rdivmod__", "__rpow__", "__rlshift__", "__rrshift__", "__rand__", "__rxor__", "__ror__", "__iadd__", "__isub__", "__imul__", "__imatmul__", "__itruediv__", "__ifloordiv__", "__imod__", "__ipow__", "__ilshift__", "__irshift__", "__iand__", "__ixor__", "__ior__", "__length_hint__");
    public static final String QUICK_FIX_MESSAGE = "Replace the raised exception with return NotImplemented";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (!functionDef.isMethodDefinition() || !OPERATOR_METHODS.contains(functionDef.name().name())) {
                return;
            }
            RaiseNotImplementedErrorVisitor visitor = new RaiseNotImplementedErrorVisitor();
            functionDef.accept((TreeVisitor)visitor);
            for (RaiseStatement notImplementedErrorRaise : visitor.nonCompliantRaises) {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)notImplementedErrorRaise, (String)"return NotImplemented")}).build();
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)notImplementedErrorRaise, MESSAGE);
                issue.addQuickFix(quickFix);
            }
        });
    }

    private static class RaiseNotImplementedErrorVisitor
    extends BaseTreeVisitor {
        private List<RaiseStatement> nonCompliantRaises = new ArrayList<RaiseStatement>();

        private RaiseNotImplementedErrorVisitor() {
        }

        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            HasSymbol hasSymbol;
            Symbol symbol;
            if (pyRaiseStatementTree.expressions().isEmpty()) {
                return;
            }
            Expression raisedException = (Expression)pyRaiseStatementTree.expressions().get(0);
            if (raisedException.type().canOnlyBe(NotImplementedErrorInOperatorMethodsCheck.NOT_IMPLEMENTED_ERROR)) {
                this.nonCompliantRaises.add(pyRaiseStatementTree);
            } else if (raisedException instanceof HasSymbol && (symbol = (hasSymbol = (HasSymbol)raisedException).symbol()) != null && NotImplementedErrorInOperatorMethodsCheck.NOT_IMPLEMENTED_ERROR.equals(symbol.fullyQualifiedName())) {
                this.nonCompliantRaises.add(pyRaiseStatementTree);
            }
        }
    }
}

