/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S2053")
public class PredictableSaltCheck
extends PythonSubscriptionCheck {
    private static final String MISSING_SALT_MESSAGE = "Add an unpredictable salt value to this hash.";
    private static final String PREDICTABLE_SALT_MESSAGE = "Make this salt unpredictable.";
    private static final String DIFFERENT_SALT_THAN_KEY_MATERIAL_MESSAGE = "Make this salt different than the derived key material.";
    private static final String SALT_IS_USED_HERE_MESSAGE = "The salt is used in the derive method here.";
    private static final String SALT_ARGUMENT_NAME = "salt";
    private static final String PASSWORD_ARGUMENT_NAME = "password";
    private static final Map<String, ArgumentInfo> SENSITIVE_ARGUMENT_BY_FQN = Map.ofEntries(Map.entry("hashlib.pbkdf2_hmac", new ArgumentInfo(2, "salt", new ArgumentInfo(1, "password"))), Map.entry("hashlib.scrypt", new ArgumentInfo(4, "salt", new ArgumentInfo(0, "password"))), Map.entry("crypt.crypt", new ArgumentInfo(1, "salt")), Map.entry("cryptography.hazmat.primitives.kdf.pbkdf2.PBKDF2HMAC", new ArgumentInfo(2, "salt")), Map.entry("cryptography.hazmat.primitives.kdf.scrypt.Scrypt", new ArgumentInfo(0, "salt")), Map.entry("Cryptodome.Protocol.KDF.PBKDF2", new ArgumentInfo(1, "salt", new ArgumentInfo(0, "password"))), Map.entry("Cryptodome.Protocol.KDF.scrypt", new ArgumentInfo(1, "salt", new ArgumentInfo(0, "password"))), Map.entry("Cryptodome.Protocol.KDF.bcrypt", new ArgumentInfo(2, "salt", new ArgumentInfo(0, "password"))), Map.entry("Crypto.Protocol.KDF.PBKDF2", new ArgumentInfo(1, "salt", new ArgumentInfo(0, "password"))), Map.entry("Crypto.Protocol.KDF.scrypt", new ArgumentInfo(1, "salt", new ArgumentInfo(0, "password"))), Map.entry("Crypto.Protocol.KDF.bcrypt", new ArgumentInfo(2, "salt", false, new ArgumentInfo(0, "password"))));
    private static final List<String> SENSITIVE_DERIVE_FUNCTIONS_FQN = List.of("cryptography.hazmat.primitives.kdf.pbkdf2.PBKDF2HMAC.derive", "cryptography.hazmat.primitives.kdf.scrypt.Scrypt.derive");
    private static final Map<String, ArgumentInfo> SALT_FUNCTION_ARGUMENTS_TO_CHECK = Map.of("bytes.fromhex", new ArgumentInfo(0, "__string"), "bytearray.fromhex", new ArgumentInfo(0, "__string"), "base64.b64decode", new ArgumentInfo(0, "s"), "base64.b64encode", new ArgumentInfo(0, "s"), "base64.b32encode", new ArgumentInfo(0, "s"), "base64.b32decode", new ArgumentInfo(0, "s"), "base64.b16encode", new ArgumentInfo(0, "s"), "base64.b16decode", new ArgumentInfo(0, "s"));
    private TypeCheckMap<ArgumentInfo> sensitiveArgumentByFqnCheck;
    private TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck;
    private List<TypeCheckBuilder> deriveFunctionsToCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.sensitiveArgumentByFqnCheck = new TypeCheckMap();
            this.saltFunctionArgumentsToCheck = new TypeCheckMap();
            this.deriveFunctionsToCheck = new ArrayList<TypeCheckBuilder>();
            PredictableSaltCheck.initializeTypeChecks(ctx, this.sensitiveArgumentByFqnCheck, this.saltFunctionArgumentsToCheck, this.deriveFunctionsToCheck);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> PredictableSaltCheck.handleCallExpression((CallExpression)ctx.syntaxNode(), ctx, this.sensitiveArgumentByFqnCheck, this.saltFunctionArgumentsToCheck, this.deriveFunctionsToCheck));
    }

    private static void initializeTypeChecks(SubscriptionContext ctx, TypeCheckMap<ArgumentInfo> sensitiveArgumentByFqnCheck, TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck, List<TypeCheckBuilder> deriveFunctionsToCheck) {
        SENSITIVE_ARGUMENT_BY_FQN.forEach((fqn, argumentNumber) -> {
            TypeCheckBuilder checker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(fqn);
            sensitiveArgumentByFqnCheck.put(checker, argumentNumber);
        });
        SALT_FUNCTION_ARGUMENTS_TO_CHECK.forEach((fqn, argumentInfo) -> {
            TypeCheckBuilder checker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(fqn);
            saltFunctionArgumentsToCheck.put(checker, argumentInfo);
        });
        SENSITIVE_DERIVE_FUNCTIONS_FQN.forEach(fqn -> {
            TypeCheckBuilder checker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(fqn);
            deriveFunctionsToCheck.add(checker);
        });
    }

    private static void handleCallExpression(CallExpression callExpression, SubscriptionContext ctx, TypeCheckMap<ArgumentInfo> sensitiveArgumentByFqnCheck, TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck, List<TypeCheckBuilder> deriveFunctionsToCheck) {
        Optional.of(callExpression).map(CallExpression::callee).map(Expression::typeV2).map(arg_0 -> sensitiveArgumentByFqnCheck.getForType(arg_0)).ifPresent(argumentInfo -> PredictableSaltCheck.checkArguments(callExpression, argumentInfo, ctx, saltFunctionArgumentsToCheck, deriveFunctionsToCheck));
    }

    private static void checkArguments(CallExpression callExpression, ArgumentInfo argumentInfo, SubscriptionContext ctx, TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck, List<TypeCheckBuilder> deriveFunctionsToCheck) {
        RegularArgument argument = TreeUtils.nthArgumentOrKeyword((int)argumentInfo.position(), (String)argumentInfo.name(), (List)callExpression.arguments());
        if (argument != null) {
            if (PredictableSaltCheck.hasRaisedOnSensitiveArgument(argument, ctx, saltFunctionArgumentsToCheck)) {
                return;
            }
            if (PredictableSaltCheck.hasRaisedOnSameArgument(argument, argumentInfo, callExpression, ctx)) {
                return;
            }
            if (PredictableSaltCheck.hasRaisedOnSameSaltAndDerivedKeyMaterial(argument, deriveFunctionsToCheck, ctx)) {
                return;
            }
        } else if (argumentInfo.required()) {
            if (callExpression.arguments().stream().noneMatch(UnpackingExpression.class::isInstance)) {
                ctx.addIssue((Tree)callExpression.callee(), MISSING_SALT_MESSAGE);
            }
        }
    }

    private static boolean hasRaisedOnSameSaltAndDerivedKeyMaterial(RegularArgument argument, List<TypeCheckBuilder> deriveFunctionsToCheck, SubscriptionContext ctx) {
        if (!argument.expression().is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return false;
        }
        SymbolV2 symbol = ((Name)argument.expression()).symbolV2();
        if (symbol == null) {
            return false;
        }
        List<Expression> usagesInDeriveCall = symbol.usages().stream().map(usage -> usage.tree().parent()).flatMap(TreeUtils.toStreamInstanceOfMapper(RegularArgument.class)).filter(regArg -> !regArg.equals(argument)).filter(regArg -> PredictableSaltCheck.isUsedInDeriveCall(regArg, deriveFunctionsToCheck)).map(RegularArgument::expression).toList();
        if (usagesInDeriveCall.isEmpty()) {
            return false;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)argument, DIFFERENT_SALT_THAN_KEY_MATERIAL_MESSAGE);
        usagesInDeriveCall.stream().forEach(arg -> issue.secondary((Tree)arg, SALT_IS_USED_HERE_MESSAGE));
        return true;
    }

    private static boolean isUsedInDeriveCall(RegularArgument regularArgument, List<TypeCheckBuilder> deriveFunctionsToCheck) {
        return Optional.ofNullable(regularArgument.parent()).flatMap(TreeUtils.toOptionalInstanceOfMapper(ArgList.class)).map(Tree::parent).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(qualifiedExpr -> deriveFunctionsToCheck.stream().anyMatch(deriveFunction -> deriveFunction.check(qualifiedExpr.name().typeV2()) == TriBool.TRUE)).orElse(false);
    }

    private static boolean hasRaisedOnSameArgument(RegularArgument argument, ArgumentInfo argumentInfo, CallExpression callExpression, SubscriptionContext ctx) {
        return Optional.ofNullable(argumentInfo.shouldNotBeSameAsArgument()).map(ai -> TreeUtils.nthArgumentOrKeyword((int)ai.position(), (String)ai.name(), (List)callExpression.arguments())).map(shouldNotBeSameAsArgument -> PredictableSaltCheck.raisedOnSameArgument(argument, shouldNotBeSameAsArgument, ctx)).orElseGet(() -> false);
    }

    private static boolean raisedOnSameArgument(RegularArgument argument, RegularArgument shouldNotBeSameAsArgument, SubscriptionContext ctx) {
        Expression exp1 = argument.expression();
        Expression exp2 = shouldNotBeSameAsArgument.expression();
        if (exp1 instanceof Name) {
            Name n1 = (Name)exp1;
            if (exp2 instanceof Name) {
                Name n2 = (Name)exp2;
                if (n1.symbolV2() == n2.symbolV2()) {
                    ctx.addIssue((Tree)argument, PREDICTABLE_SALT_MESSAGE).secondary((Tree)shouldNotBeSameAsArgument, "");
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasRaisedOnSensitiveArgument(RegularArgument regularArgument, SubscriptionContext ctx, TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck) {
        ArrayList<Tree> secondaries = new ArrayList<Tree>();
        Expression expression = regularArgument.expression();
        while (expression != null) {
            if (expression instanceof Name) {
                Name name = (Name)expression;
                expression = PredictableSaltCheck.getNameAssignedValueToCheck(name, secondaries);
                continue;
            }
            if (expression instanceof CallExpression) {
                CallExpression callExpression = (CallExpression)expression;
                expression = PredictableSaltCheck.getCallExpressionArgumentValueToCheck(saltFunctionArgumentsToCheck, callExpression, expression);
                continue;
            }
            if (expression instanceof StringLiteral) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)regularArgument, PREDICTABLE_SALT_MESSAGE);
                secondaries.forEach(t -> issue.secondary(t, ""));
                return true;
            }
            expression = null;
        }
        return false;
    }

    private static Expression getNameAssignedValueToCheck(Name name, ArrayList<Tree> secondaries) {
        Expression expression = Expressions.singleAssignedValue(name);
        if (expression != null) {
            Tree assignmentStatement = TreeUtils.firstAncestorOfKind((Tree)expression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
            secondaries.add(assignmentStatement);
        }
        return expression;
    }

    private static Expression getCallExpressionArgumentValueToCheck(TypeCheckMap<ArgumentInfo> saltFunctionArgumentsToCheck, CallExpression callExpression, Expression expression) {
        return Optional.of(callExpression).map(CallExpression::callee).map(Expression::typeV2).map(arg_0 -> saltFunctionArgumentsToCheck.getForType(arg_0)).map(argumentInfo -> Optional.ofNullable(TreeUtils.nthArgumentOrKeyword((int)argumentInfo.position(), (String)argumentInfo.name(), (List)callExpression.arguments())).map(RegularArgument::expression).orElse(expression)).orElse(null);
    }

    private record ArgumentInfo(int position, String name, boolean required, @Nullable ArgumentInfo shouldNotBeSameAsArgument) {
        private ArgumentInfo(int position, String name) {
            this(position, name, true, null);
        }

        private ArgumentInfo(int position, String name, ArgumentInfo shouldNotBeSameAsArgument) {
            this(position, name, true, shouldNotBeSameAsArgument);
        }
    }
}

