/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7500")
public class UnnecessaryComprehensionCheck
extends PythonSubscriptionCheck {
    private static final Map<Tree.Kind, String> COMPREHENSION_TO_QUICK_FIX_FORMAT_MAPPING = Map.of(Tree.Kind.GENERATOR_EXPR, "%s", Tree.Kind.LIST_COMPREHENSION, "list(%s)", Tree.Kind.SET_COMPREHENSION, "set(%s)", Tree.Kind.DICT_COMPREHENSION, "dict(%s)");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.GENERATOR_EXPR, UnnecessaryComprehensionCheck::checkComprehensionExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.LIST_COMPREHENSION, UnnecessaryComprehensionCheck::checkComprehensionExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_COMPREHENSION, UnnecessaryComprehensionCheck::checkComprehensionExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, UnnecessaryComprehensionCheck::checkDictComprehensionExpression);
    }

    private static void checkComprehensionExpression(SubscriptionContext ctx) {
        ComprehensionExpression comprehension = (ComprehensionExpression)ctx.syntaxNode();
        Expression valueExpression = comprehension.resultExpression();
        Expression loopExpression = Optional.of(comprehension).map(ComprehensionExpression::comprehensionFor).filter(comprehensionFor -> Objects.isNull(comprehensionFor.nestedClause())).map(ComprehensionFor::loopExpression).orElse(null);
        if (valueExpression instanceof Name) {
            Name valueName = (Name)valueExpression;
            if (loopExpression instanceof Name) {
                Name loopValueName = (Name)loopExpression;
                if (valueName.name().equals(loopValueName.name())) {
                    PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)comprehension, "Replace this comprehension with passing the iterable to the collection constructor call");
                    UnnecessaryComprehensionCheck.createQuickFix((Tree)comprehension, comprehension.comprehensionFor()).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
                }
            }
        }
    }

    private static void checkDictComprehensionExpression(SubscriptionContext ctx) {
        DictCompExpression comprehension = (DictCompExpression)ctx.syntaxNode();
        Expression keyExpression = comprehension.keyExpression();
        Expression valueExpression = comprehension.valueExpression();
        List loopExpressions = Optional.of(comprehension).map(DictCompExpression::comprehensionFor).filter(comprehensionFor -> Objects.isNull(comprehensionFor.nestedClause())).map(ComprehensionFor::loopExpression).map(TreeUtils.toInstanceOfMapper(Tuple.class)).map(Tuple::elements).orElseGet(List::of);
        if (keyExpression instanceof Name) {
            Name keyName = (Name)keyExpression;
            if (valueExpression instanceof Name) {
                Object e;
                Name valueName = (Name)valueExpression;
                if (loopExpressions.size() == 2 && (e = loopExpressions.get(0)) instanceof Name) {
                    Name loopKeyName = (Name)e;
                    e = loopExpressions.get(1);
                    if (e instanceof Name) {
                        Name loopValueName = (Name)e;
                        if (keyName.name().equals(loopKeyName.name()) && valueName.name().equals(loopValueName.name())) {
                            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)comprehension, "Replace this comprehension with passing the iterable to the dict constructor call");
                            UnnecessaryComprehensionCheck.createQuickFix((Tree)comprehension, comprehension.comprehensionFor()).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
                        }
                    }
                }
            }
        }
    }

    private static Optional<PythonQuickFix> createQuickFix(Tree comprehension, ComprehensionFor comprehensionFor) {
        return Optional.ofNullable(TreeUtils.treeToString((Tree)comprehensionFor.iterable(), (boolean)false)).flatMap(iterableString -> Optional.ofNullable(COMPREHENSION_TO_QUICK_FIX_FORMAT_MAPPING.getOrDefault(comprehension.getKind(), null)).map(format -> format.formatted(iterableString)).map(replacementText -> TextEditUtils.replace((Tree)comprehension, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)"Replace with collection constructor call").addTextEdit(new PythonTextEdit[]{textEdit})).map(PythonQuickFix.Builder::build));
    }
}

