/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tests.UnittestUtils;

@Rule(key="S5918")
public class ImplicitlySkippedTestCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Skip this test explicitly.";
    private static final String MESSAGE_RETURN_SKIP = "Remove this return, it is not needed to skip the test.";
    private static final Tree.Kind[] literalsKind = new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.LIST_LITERAL, Tree.Kind.BOOLEAN_LITERAL_PATTERN, Tree.Kind.NUMERIC_LITERAL_PATTERN, Tree.Kind.NONE_LITERAL_PATTERN, Tree.Kind.STRING_LITERAL_PATTERN};

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (!functionDef.name().name().startsWith("test")) {
                return;
            }
            ReturnStatement returnStatement = ImplicitlySkippedTestCheck.getReturnStatementFromFirstIfStatement(functionDef);
            if (returnStatement == null) {
                return;
            }
            if (ImplicitlySkippedTestCheck.hasAnySkipStatement(returnStatement.expressions())) {
                ctx.addIssue(returnStatement.returnKeyword(), MESSAGE_RETURN_SKIP);
                return;
            }
            if (ImplicitlySkippedTestCheck.containsAssertion(functionDef)) {
                ctx.addIssue((Tree)returnStatement, MESSAGE);
            }
        });
    }

    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }

    private static ReturnStatement getReturnStatementFromFirstIfStatement(FunctionDef functionDef) {
        for (Statement statement : functionDef.body().statements()) {
            IfStatement ifStatement;
            List statements;
            if (statement.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)statement).assignedValue().is(literalsKind)) continue;
            if (statement.is(new Tree.Kind[]{Tree.Kind.IF_STMT}) && ((Statement)(statements = (ifStatement = (IfStatement)statement).body().statements()).get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STMT})) {
                return (ReturnStatement)statements.get(0);
            }
            return null;
        }
        return null;
    }

    private static boolean hasAnySkipStatement(List<Expression> expressions) {
        return expressions.stream().filter(expression -> expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})).map(CallExpression.class::cast).filter(callExpr -> callExpr.callee().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})).map(callExpr -> (QualifiedExpression)callExpr.callee()).anyMatch(callExpr -> ImplicitlySkippedTestCheck.isPytestSkip(callExpr) || ImplicitlySkippedTestCheck.isUnittestSkip(callExpr));
    }

    private static boolean isPytestSkip(QualifiedExpression qualifiedExpression) {
        return Optional.of(qualifiedExpression).stream().map(qualifExpr -> qualifExpr.name().symbol()).filter(Objects::nonNull).anyMatch(symbol -> "pytest.skip".equals(symbol.fullyQualifiedName()));
    }

    private static boolean isUnittestSkip(QualifiedExpression qualifiedExpression) {
        return Optional.of(qualifiedExpression).stream().anyMatch(qualifExpr -> qualifExpr.qualifier().is(new Tree.Kind[]{Tree.Kind.NAME}) && "self".equals(((Name)qualifExpr.qualifier()).name()) && "skipTest".equals(qualifExpr.name().name()));
    }

    private static boolean containsAssertion(FunctionDef functionDef) {
        Set<String> supportedAssertMethods = UnittestUtils.isWithinUnittestTestCase((Tree)functionDef) ? UnittestUtils.allAssertMethods() : Collections.emptySet();
        AssertionVisitor assertVisitor = new AssertionVisitor(supportedAssertMethods);
        functionDef.accept((TreeVisitor)assertVisitor);
        return assertVisitor.hasAnAssert;
    }

    static class AssertionVisitor
    extends BaseTreeVisitor {
        boolean hasAnAssert = false;
        Set<String> supportedMethods;

        public AssertionVisitor(Set<String> supportedMethods) {
            this.supportedMethods = supportedMethods;
        }

        public void visitAssertStatement(AssertStatement assertStatement) {
            this.hasAnAssert = true;
            super.visitAssertStatement(assertStatement);
        }

        public void visitCallExpression(CallExpression callExpression) {
            QualifiedExpression qualifiedExpression;
            if (callExpression.callee().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR}) && (qualifiedExpression = (QualifiedExpression)callExpression.callee()).qualifier().is(new Tree.Kind[]{Tree.Kind.NAME}) && "self".equals(((Name)qualifiedExpression.qualifier()).name()) && this.supportedMethods.contains(qualifiedExpression.name().name())) {
                this.hasAnAssert = true;
            }
            super.visitCallExpression(callExpression);
        }
    }
}

