/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeChecker;

@Rule(key="S5795")
public class IdentityComparisonWithCachedTypesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_IS = "Replace this \"is\" operator with \"==\"; identity operator is not reliable here.";
    private static final String MESSAGE_IS_NOT = "Replace this \"is not\" operator with \"!=\"; identity operator is not reliable here.";
    public static final String IS_QUICK_FIX_MESSAGE = "Replace with \"==\"";
    public static final String IS_NOT_QUICK_FIX_MESSAGE = "Replace with \"!=\"";
    private static final List<String> FQNS_CONSTRUCTORS_RETURNING_UNIQUE_REF = Arrays.asList("frozenset", "bytes", "int", "float", "str", "tuple", "hash");
    private static final List<String> NAMES_OF_TYPES_UNSUITABLE_FOR_COMPARISON = Arrays.asList("frozenset", "bytes", "int", "float", "tuple");
    private TypeChecker typeChecker;
    private TypeCheckBuilder isNoneTypeChecker;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.typeChecker = ctx.typeChecker();
            this.isNoneTypeChecker = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("NoneType");
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, this::checkIsComparison);
    }

    private void checkIsComparison(SubscriptionContext ctx) {
        IsExpression isExpr = (IsExpression)ctx.syntaxNode();
        if (this.isComparisonToNone(isExpr)) {
            return;
        }
        if (this.isUnsuitableOperand(isExpr.leftOperand()) || this.isUnsuitableOperand(isExpr.rightOperand())) {
            Token notToken = isExpr.notToken();
            if (notToken == null) {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)IS_QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)isExpr.operator(), (String)"==")}).build();
                PythonCheck.PreciseIssue issue = ctx.addIssue(isExpr.operator(), MESSAGE_IS);
                issue.addQuickFix(quickFix);
            } else {
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)IS_NOT_QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)isExpr.operator(), (String)"!=")}).addTextEdit(new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)notToken, (Tree)isExpr.rightOperand())}).build();
                PythonCheck.PreciseIssue issue = ctx.addIssue(isExpr.operator(), notToken, MESSAGE_IS_NOT);
                issue.addQuickFix(quickFix);
            }
        }
    }

    private boolean isComparisonToNone(IsExpression isExpr) {
        return this.isNone(isExpr.leftOperand().typeV2()) || this.isNone(isExpr.rightOperand().typeV2());
    }

    private boolean isNone(PythonType type) {
        return this.isNoneTypeChecker.check(type) == TriBool.TRUE;
    }

    private boolean isUnsuitableOperand(Expression expr) {
        PythonType type = expr.typeV2();
        if (this.isUnsuitableType(type)) {
            if (expr instanceof Name) {
                Name name = (Name)expr;
                SymbolV2 symbol = name.symbolV2();
                return symbol != null && !IdentityComparisonWithCachedTypesCheck.isVariableThatCanEscape(symbol);
            }
            return true;
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return true;
        }
        if (expr instanceof CallExpression) {
            CallExpression callExpr = (CallExpression)expr;
            PythonType calleeType = callExpr.callee().typeV2();
            return this.isConstructorReturningUniqueRef(calleeType);
        }
        return false;
    }

    private boolean isUnsuitableType(PythonType type) {
        for (String builtinName : NAMES_OF_TYPES_UNSUITABLE_FOR_COMPARISON) {
            TypeCheckBuilder builtinWithNameChecker = this.typeChecker.typeCheckBuilder().isInstance().isBuiltinWithName(builtinName);
            if (builtinWithNameChecker.check(type) != TriBool.TRUE) continue;
            return true;
        }
        return false;
    }

    private boolean isConstructorReturningUniqueRef(PythonType type) {
        for (String constructorName : FQNS_CONSTRUCTORS_RETURNING_UNIQUE_REF) {
            TypeCheckBuilder constructorChecker = this.typeChecker.typeCheckBuilder().isTypeWithName(constructorName);
            if (constructorChecker.check(type) != TriBool.TRUE) continue;
            return true;
        }
        return false;
    }

    private static boolean isVariableThatCanEscape(SymbolV2 symb) {
        List usages = symb.usages();
        if (usages.size() > 2) {
            return usages.stream().anyMatch(u -> !u.isBindingUsage() && TreeUtils.firstAncestorOfKind((Tree)u.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.IS}) == null);
        }
        return false;
    }
}

