/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7517")
public class LoopOverDictKeyValuesCheck
extends PythonSubscriptionCheck {
    private static final String DICT_FQN = "dict";
    private static final String MESSAGE = "Use items to iterate over key-value pairs";
    private static final String QUICK_FIX_MESSAGE = "Replace with items method call";
    private TypeCheckBuilder dictTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::checkForStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, this::checkComprehensionFor);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.dictTypeCheck = ctx.typeChecker().typeCheckBuilder().isInstanceOf(DICT_FQN);
    }

    private void checkForStatement(SubscriptionContext ctx) {
        ForStatement forStatement = (ForStatement)ctx.syntaxNode();
        List expressions = forStatement.expressions();
        List testExpressions = forStatement.testExpressions();
        if (expressions.size() == 2 && testExpressions.size() == 1 && this.dictTypeCheck.check(((Expression)testExpressions.get(0)).typeV2()) == TriBool.TRUE) {
            Expression dict = (Expression)testExpressions.get(0);
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)dict, MESSAGE);
            LoopOverDictKeyValuesCheck.createQuickFix(dict).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
        }
    }

    private void checkComprehensionFor(SubscriptionContext ctx) {
        Tuple tuple;
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        Expression expression = comprehensionFor.loopExpression();
        if (expression instanceof Tuple && (tuple = (Tuple)expression).elements().size() == 2 && this.dictTypeCheck.check(comprehensionFor.iterable().typeV2()) == TriBool.TRUE) {
            Expression dict = comprehensionFor.iterable();
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)dict, MESSAGE);
            LoopOverDictKeyValuesCheck.createQuickFix(dict).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
        }
    }

    private static Optional<PythonQuickFix> createQuickFix(Expression dict) {
        return Optional.ofNullable(TreeUtils.treeToString((Tree)dict, (boolean)false)).map(arg_0 -> LoopOverDictKeyValuesCheck.lambda$createQuickFix$0("%s.items()", arg_0)).map(replacementText -> TextEditUtils.replace((Tree)dict, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{textEdit})).map(PythonQuickFix.Builder::build);
    }

    private static /* synthetic */ String lambda$createQuickFix$0(String rec$, Object xva$0) {
        return "%s.items()".formatted(xva$0);
    }
}

