/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7508")
public class NestedCollectionsCreationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this redundant call.";
    private static final String QUICK_FIX_MESSAGE = "Remove this redundant call.";
    private static final String LIST_FQN = "list";
    private static final String SORTED_FQN = "sorted";
    private static final String SET_FQN = "set";
    private static final String TUPLE_FQN = "tuple";
    private static final String REVERSED_FQN = "reversed";
    private static final Map<String, Set<String>> SENSITIVE_NESTED_CALL_COMBINATIONS = Map.ofEntries(Map.entry("list", Set.of("list", "tuple", "sorted")), Map.entry("set", Set.of("list", "set", "tuple", "reversed", "sorted")), Map.entry("sorted", Set.of("list", "tuple", "sorted")), Map.entry("tuple", Set.of("list", "tuple")));
    private TypeCheckMap<Set<TypeCheckBuilder>> sensitiveCallCombinationChecks;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.sensitiveCallCombinationChecks = new TypeCheckMap();
        SENSITIVE_NESTED_CALL_COMBINATIONS.forEach((outerCallFqn, innerCallFqns) -> {
            TypeCheckBuilder outerCallTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName(outerCallFqn);
            Set innerCallTypeChecks = innerCallFqns.stream().map(sensitiveMethodFqn -> ctx.typeChecker().typeCheckBuilder().isTypeWithName(sensitiveMethodFqn)).collect(Collectors.toSet());
            this.sensitiveCallCombinationChecks.put(outerCallTypeCheck, innerCallTypeChecks);
        });
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        this.sensitiveCallCombinationChecks.getOptionalForType(callExpression.callee().typeV2()).ifPresent(nestedCallTypeChecks -> TreeUtils.nthArgumentOrKeywordOptional((int)0, (String)"", (List)callExpression.arguments()).map(RegularArgument::expression).ifPresent(argumentExpression -> {
            NestedCollectionsCreationCheck.findSensitiveMethodCall(argumentExpression, nestedCallTypeChecks).ifPresent(redundantCallExpression -> {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callExpression, "Remove this redundant call.");
                NestedCollectionsCreationCheck.createQuickFix((Expression)redundantCallExpression).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
            });
            NestedCollectionsCreationCheck.findAssignedToSensitiveMethodCall(argumentExpression, nestedCallTypeChecks).ifPresent(argumentAssignedCall -> {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callExpression, "Remove this redundant call.");
                NestedCollectionsCreationCheck.createAssignedQuickFix(argumentExpression, (Expression)argumentAssignedCall).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
            });
        }));
    }

    private static Optional<CallExpression> findSensitiveMethodCall(@Nullable Expression expression, Set<TypeCheckBuilder> sensitiveMethodsTypeChecks) {
        return TreeUtils.toOptionalInstanceOf(CallExpression.class, (Tree)expression).filter(callExpression -> sensitiveMethodsTypeChecks.stream().map(check -> check.check(callExpression.callee().typeV2())).anyMatch(arg_0 -> TriBool.TRUE.equals(arg_0)));
    }

    private static Optional<CallExpression> findAssignedToSensitiveMethodCall(Expression argumentExpression, Set<TypeCheckBuilder> sensitiveMethodsTypeChecks) {
        return TreeUtils.toOptionalInstanceOf(Name.class, (Tree)argumentExpression).filter(name -> NestedCollectionsCreationCheck.getUsageCount(name) == 2).flatMap(name -> NestedCollectionsCreationCheck.findSensitiveMethodCall(Expressions.singleAssignedValue(name), sensitiveMethodsTypeChecks));
    }

    private static int getUsageCount(Name name) {
        return Optional.ofNullable(name.symbolV2()).map(SymbolV2::usages).map(List::size).orElse(0);
    }

    private static Optional<PythonQuickFix> createQuickFix(Expression argumentCall) {
        return TreeUtils.toOptionalInstanceOf(CallExpression.class, (Tree)argumentCall).map(CallExpression::argumentList).map(argList -> TreeUtils.treeToString((Tree)argList, (boolean)false)).map(replacementText -> TextEditUtils.replace((Tree)argumentCall, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)"Remove this redundant call.").addTextEdit(new PythonTextEdit[]{textEdit})).map(PythonQuickFix.Builder::build);
    }

    private static Optional<PythonQuickFix> createAssignedQuickFix(Expression argumentExpression, Expression argumentAssignedValueCall) {
        return TreeUtils.toOptionalInstanceOf(CallExpression.class, (Tree)argumentAssignedValueCall).map(CallExpression::argumentList).map(argList -> TreeUtils.treeToString((Tree)argList, (boolean)false)).map(replacementText -> {
            PythonQuickFix.Builder quickFix = PythonQuickFix.newQuickFix((String)"Remove this redundant call.").addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)argumentExpression, (String)replacementText)});
            TreeUtils.toOptionalInstanceOf(Statement.class, (Tree)TreeUtils.firstAncestor((Tree)argumentAssignedValueCall, Statement.class::isInstance)).map(TextEditUtils::removeStatement).ifPresent(xva$0 -> quickFix.addTextEdit(new PythonTextEdit[]{xva$0}));
            return quickFix.build();
        });
    }
}

