/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6983")
public class PyTorchDataLoaderNumWorkersCheck
extends PythonSubscriptionCheck {
    private static final String TORCH_UTILS_DATA_DATA_LOADER = "torch.utils.data.DataLoader";
    public static final String MESSAGE = "Specify the `num_workers` parameter.";
    public static final String NUM_WORKERS_ARG_NAME = "num_workers";
    public static final int NUM_WORKERS_ARG_POSITION = 5;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            List arguments = callExpression.arguments();
            if (calleeSymbol != null && TORCH_UTILS_DATA_DATA_LOADER.equals(calleeSymbol.fullyQualifiedName()) && PyTorchDataLoaderNumWorkersCheck.isNumWorkersArgPresent(arguments) && !PyTorchDataLoaderNumWorkersCheck.isUnpackArgPresent(arguments)) {
                ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
            }
        });
    }

    private static boolean isNumWorkersArgPresent(List<Argument> arguments) {
        return TreeUtils.nthArgumentOrKeyword((int)5, (String)NUM_WORKERS_ARG_NAME, arguments) == null;
    }

    private static boolean isUnpackArgPresent(List<Argument> arguments) {
        return arguments.stream().anyMatch(UnpackingExpression.class::isInstance);
    }
}

