/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7493")
public class SynchronousFileOperationsInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use an asynchronous file API instead of synchronous %s() in this async function.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private TypeCheckMap<String> syncFileFunctions;
    private static final List<String> SYNC_FILE_FUNCTIONS = List.of("open", "os.open", "pathlib.Path.open", "codecs.open", "os.fdopen", "os.popen", "tempfile.TemporaryFile", "tempfile.NamedTemporaryFile", "tempfile.SpooledTemporaryFile", "gzip.open", "bz2.open", "lzma.open");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckMap);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void initializeTypeCheckMap(SubscriptionContext context) {
        this.syncFileFunctions = new TypeCheckMap();
        SYNC_FILE_FUNCTIONS.forEach(fqn -> this.syncFileFunctions.put(context.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(fqn), fqn));
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction((Tree)callExpression).orElse(null);
        if (asyncToken == null) {
            return;
        }
        this.syncFileFunctions.getOptionalForType(callExpression.callee().typeV2()).ifPresent(functionName -> ctx.addIssue((Tree)callExpression, String.format(MESSAGE, functionName)).secondary(asyncToken, SECONDARY_MESSAGE));
    }
}

