/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.function.BiConsumer;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

public class CommonValidationUtils {
    private CommonValidationUtils() {
    }

    static boolean isLessThan(Expression expression, int number) {
        try {
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
                return Expressions.singleAssignedNonNameValue((Name)expression).map(value -> CommonValidationUtils.isLessThan(value, number)).orElse(false);
            }
            return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)expression).valueAsLong() < (long)number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isMoreThan(Expression expression, int number) {
        try {
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
                return Expressions.singleAssignedNonNameValue((Name)expression).map(value -> CommonValidationUtils.isMoreThan(value, number)).orElse(false);
            }
            return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)expression).valueAsLong() > (long)number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    static boolean isLessThanExponent(Expression expression, int exponent) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.SHIFT_EXPR})) {
            BinaryExpression shiftExpression = (BinaryExpression)expression;
            return shiftExpression.leftOperand().is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)shiftExpression.leftOperand()).valueAsLong() == 1L && CommonValidationUtils.isLessThan(shiftExpression.rightOperand(), exponent);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return Expressions.singleAssignedNonNameValue((Name)expression).map(v -> CommonValidationUtils.isLessThanExponent(v, exponent)).orElse(false);
        }
        return false;
    }

    public static boolean isEqualTo(Expression expression, int number) {
        try {
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
                return Expressions.singleAssignedNonNameValue((Name)expression).map(value -> CommonValidationUtils.isEqualTo(value, number)).orElse(false);
            }
            return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && (CommonValidationUtils.isNumericLiteralEqualToInt((NumericLiteral)expression, number) || CommonValidationUtils.isNumericLiteralEqualToDouble((NumericLiteral)expression, number));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean isNumericLiteralEqualToInt(NumericLiteral numericLiteral, int number) {
        try {
            return numericLiteral.valueAsLong() == (long)number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean isNumericLiteralEqualToDouble(NumericLiteral numericLiteral, double number) {
        try {
            return Double.parseDouble(numericLiteral.valueAsString()) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    static String singleAssignedString(Expression expression) {
        if (expression instanceof Name) {
            Name name = (Name)expression;
            return Expressions.singleAssignedNonNameValue(name).map(CommonValidationUtils::singleAssignedString).orElse("");
        }
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? ((StringLiteral)expression).trimmedQuotesValue() : "";
    }

    record ArgumentValidator(int position, String keywordName, BiConsumer<SubscriptionContext, RegularArgument> consumer) implements CallValidator
    {
        @Override
        public void validate(SubscriptionContext ctx, CallExpression callExpression) {
            TreeUtils.nthArgumentOrKeywordOptional((int)this.position, (String)this.keywordName, (List)callExpression.arguments()).ifPresent(argument -> this.consumer.accept(ctx, (RegularArgument)argument));
        }
    }

    static interface CallValidator {
        public void validate(SubscriptionContext var1, CallExpression var2);
    }
}

